/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.CommandDescriptor;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationDetails;

public final class MigrationCmdRegistry {
    private static Logger LOGGER = Logger.getLogger(MigrationCmdRegistry.class.toString());
    private static final HashMap<String, Class<? extends MigrationCmd>> _cmdRegistry = new HashMap();
    private static final HashMap<String, CommandDescriptor> _cmdMetaRegistry = new HashMap();

    public static final synchronized MigrationCmd getMigrationCmd(String string, MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) throws Exception {
        MigrationCmd migrationCmd = null;
        MigrationCmdRegistry.getCommand(string);
        Class[] classArray = null;
        if (_cmdRegistry.get(string) != null) {
            classArray = new Class[]{MigrationDetails.class, CMDOut.class, Boolean.TYPE};
            migrationCmd = _cmdRegistry.get(string).getConstructor(classArray).newInstance(migrationDetails, cMDOut, bl);
            if (migrationCmd == null) {
                // empty if block
            }
        }
        return migrationCmd;
    }

    public static MigrationCmd getCommand(String string) {
        MigrationCmd migrationCmd = null;
        try {
            if (_cmdMetaRegistry != null && _cmdMetaRegistry.get(string) != null && _cmdMetaRegistry.get(string).getMetaClazz() != null) {
                _cmdMetaRegistry.get(string).getMetaClazz().newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
            LOGGER.log(Level.SEVERE, instantiationException.getLocalizedMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.log(Level.SEVERE, illegalAccessException.getLocalizedMessage(), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.log(Level.SEVERE, classNotFoundException.getLocalizedMessage(), classNotFoundException);
        }
        return migrationCmd;
    }

    public static final synchronized void registerMigrationCmd(String string, Class<? extends MigrationCmd> clazz) {
        if (string != null && string.trim().length() > 0 && _cmdRegistry.get(string) == null) {
            _cmdRegistry.put(string, clazz);
        }
    }

    public static final synchronized void registerCmdHook(String string, String string2, MetaClass<? extends MigrationCmd> metaClass) {
        if (!_cmdMetaRegistry.containsKey(string)) {
            CommandDescriptor commandDescriptor = new CommandDescriptor(string, string2, metaClass);
            _cmdMetaRegistry.put(string, commandDescriptor);
        }
    }
}

