/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdConnection
extends PersistableObject {
    public static final String TABLE_NAME = "MD_CONNECTIONS";
    public static final String COLNAME_PROJECT_ID_FK = "PROJECT_ID_FK";
    public static final String COLNAME_TYPE = "TYPE";
    public static final String COLNAME_HOST = "HOST";
    public static final String COLNAME_PORT = "PORT";
    public static final String COLNAME_USERNAME = "USERNAME";
    public static final String COLNAME_PASSWORD = "PASSWORD";
    public static final String COLNAME_DBURL = "DBURL";
    public static final String COLNAME_NAME = "NAME";
    public static final String COLNAME_NATIVE_SQL = "NATIVE_SQL";
    public static final String COLNAME_STATUS = "STATUS";
    public static final String COLNAME_NUM_CATALOGS = "NUM_CATALOGS";
    public static final String COLNAME_NUM_COLUMNS = "NUM_COLUMNS";
    public static final String COLNAME_NUM_CONSTRAINTS = "NUM_CONSTRAINTS";
    public static final String COLNAME_NUM_GROUPS = "NUM_GROUPS";
    public static final String COLNAME_NUM_ROLES = "NUM_ROLES";
    public static final String COLNAME_NUM_INDEXES = "NUM_INDEXES";
    public static final String COLNAME_NUM_OTHER_OBJECTS = "NUM_OTHER_OBJECTS";
    public static final String COLNAME_NUM_PACKAGES = "NUM_PACKAGES";
    public static final String COLNAME_NUM_PRIVILEGES = "NUM_PRIVILEGES";
    public static final String COLNAME_NUM_SCHEMAS = "NUM_SCHEMAS";
    public static final String COLNAME_NUM_SEQUENCES = "NUM_SEQUENCES";
    public static final String COLNAME_NUM_STORED_PROGRAMS = "NUM_STORED_PROGRAMS";
    public static final String COLNAME_NUM_SYNONYMS = "NUM_SYNONYMS";
    public static final String COLNAME_NUM_TABLES = "NUM_TABLES";
    public static final String COLNAME_NUM_TABLESPACES = "NUM_TABLESPACES";
    public static final String COLNAME_NUM_TRIGGERS = "NUM_TRIGGERS";
    public static final String COLNAME_NUM_USER_DEFINED_DATA_TYPES = "NUM_USER_DEFINED_DATA_TYPES";
    public static final String COLNAME_NUM_USERS = "NUM_USERS";
    public static final String COLNAME_NUM_VIEWS = "NUM_VIEWS";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdConnection(DBObjectId dBObjectId) {
        this.setProjectId(dBObjectId);
    }

    public static MdConnection getExistingInstance(DBObjectId dBObjectId) {
        MdConnection mdConnection = new MdConnection();
        mdConnection.setKey(dBObjectId);
        return mdConnection;
    }

    private MdConnection() {
    }

    public static MdConnection retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdConnection mdConnection = MdConnection.getExistingInstance(dBObjectId);
        mdConnection.retrieve(persistenceManager);
        return mdConnection;
    }

    protected void setProjectId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_PROJECT_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setType(String string) {
        Field field = new Field(COLNAME_TYPE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setHost(String string) {
        Field field = new Field(COLNAME_HOST, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setPort(Integer n) {
        Field field = new Field(COLNAME_PORT, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setUsername(String string) {
        Field field = new Field(COLNAME_USERNAME, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setPassword(String string) {
        Field field = new Field(COLNAME_PASSWORD, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setDburl(String string) {
        Field field = new Field(COLNAME_DBURL, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setName(String string) {
        Field field = new Field(COLNAME_NAME, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setNativeSql(String string) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(string);
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setNativeSql(ClobHelper clobHelper) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setStatus(String string) {
        Field field = new Field(COLNAME_STATUS, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setNumCatalogs(Integer n) {
        Field field = new Field(COLNAME_NUM_CATALOGS, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumColumns(Integer n) {
        Field field = new Field(COLNAME_NUM_COLUMNS, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumConstraints(Integer n) {
        Field field = new Field(COLNAME_NUM_CONSTRAINTS, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumGroups(Integer n) {
        Field field = new Field(COLNAME_NUM_GROUPS, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumRoles(Integer n) {
        Field field = new Field(COLNAME_NUM_ROLES, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumIndexes(Integer n) {
        Field field = new Field(COLNAME_NUM_INDEXES, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumOtherObjects(Integer n) {
        Field field = new Field(COLNAME_NUM_OTHER_OBJECTS, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumPackages(Integer n) {
        Field field = new Field(COLNAME_NUM_PACKAGES, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumPrivileges(Integer n) {
        Field field = new Field(COLNAME_NUM_PRIVILEGES, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumSchemas(Integer n) {
        Field field = new Field(COLNAME_NUM_SCHEMAS, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumSequences(Integer n) {
        Field field = new Field(COLNAME_NUM_SEQUENCES, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumStoredPrograms(Integer n) {
        Field field = new Field(COLNAME_NUM_STORED_PROGRAMS, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumSynonyms(Integer n) {
        Field field = new Field(COLNAME_NUM_SYNONYMS, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumTables(Integer n) {
        Field field = new Field(COLNAME_NUM_TABLES, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumTablespaces(Integer n) {
        Field field = new Field(COLNAME_NUM_TABLESPACES, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumTriggers(Integer n) {
        Field field = new Field(COLNAME_NUM_TRIGGERS, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumUserDefinedDataTypes(Integer n) {
        Field field = new Field(COLNAME_NUM_USER_DEFINED_DATA_TYPES, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumUsers(Integer n) {
        Field field = new Field(COLNAME_NUM_USERS, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setNumViews(Integer n) {
        Field field = new Field(COLNAME_NUM_VIEWS, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setComments(String string) {
        Field field = new Field(COLNAME_COMMENTS, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getProjectId() {
        Field field = this.getField(COLNAME_PROJECT_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getType() {
        Field field = this.getField(COLNAME_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getHost() {
        Field field = this.getField(COLNAME_HOST);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getPort() {
        Field field = this.getField(COLNAME_PORT);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public String getUsername() {
        Field field = this.getField(COLNAME_USERNAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getPassword() {
        Field field = this.getField(COLNAME_PASSWORD);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getDburl() {
        Field field = this.getField(COLNAME_DBURL);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getName() {
        Field field = this.getField(COLNAME_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public ClobHelper getNativeSql() {
        Field field = this.getField(COLNAME_NATIVE_SQL);
        if (field == null) {
            return null;
        }
        return field.getClobHelper();
    }

    public String getStatus() {
        Field field = this.getField(COLNAME_STATUS);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getNumCatalogs() {
        Field field = this.getField(COLNAME_NUM_CATALOGS);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumColumns() {
        Field field = this.getField(COLNAME_NUM_COLUMNS);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumConstraints() {
        Field field = this.getField(COLNAME_NUM_CONSTRAINTS);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumGroups() {
        Field field = this.getField(COLNAME_NUM_GROUPS);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumRoles() {
        Field field = this.getField(COLNAME_NUM_ROLES);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumIndexes() {
        Field field = this.getField(COLNAME_NUM_INDEXES);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumOtherObjects() {
        Field field = this.getField(COLNAME_NUM_OTHER_OBJECTS);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumPackages() {
        Field field = this.getField(COLNAME_NUM_PACKAGES);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumPrivileges() {
        Field field = this.getField(COLNAME_NUM_PRIVILEGES);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumSchemas() {
        Field field = this.getField(COLNAME_NUM_SCHEMAS);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumSequences() {
        Field field = this.getField(COLNAME_NUM_SEQUENCES);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumStoredPrograms() {
        Field field = this.getField(COLNAME_NUM_STORED_PROGRAMS);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumSynonyms() {
        Field field = this.getField(COLNAME_NUM_SYNONYMS);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumTables() {
        Field field = this.getField(COLNAME_NUM_TABLES);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumTablespaces() {
        Field field = this.getField(COLNAME_NUM_TABLESPACES);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumTriggers() {
        Field field = this.getField(COLNAME_NUM_TRIGGERS);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumUserDefinedDataTypes() {
        Field field = this.getField(COLNAME_NUM_USER_DEFINED_DATA_TYPES);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumUsers() {
        Field field = this.getField(COLNAME_NUM_USERS);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getNumViews() {
        Field field = this.getField(COLNAME_NUM_VIEWS);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public String getComments() {
        Field field = this.getField(COLNAME_COMMENTS);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setProjectId(new DBObjectId(resultSet.getLong(COLNAME_PROJECT_ID_FK)));
            Object object = resultSet.getString(COLNAME_TYPE);
            if (resultSet.wasNull()) {
                this.setType(null);
            } else {
                this.setType((String)object);
            }
            object = resultSet.getString(COLNAME_HOST);
            if (resultSet.wasNull()) {
                this.setHost(null);
            } else {
                this.setHost((String)object);
            }
            object = resultSet.getInt(COLNAME_PORT);
            if (resultSet.wasNull()) {
                this.setPort(null);
            } else {
                this.setPort((Integer)object);
            }
            object = resultSet.getString(COLNAME_USERNAME);
            if (resultSet.wasNull()) {
                this.setUsername(null);
            } else {
                this.setUsername((String)object);
            }
            object = resultSet.getString(COLNAME_PASSWORD);
            if (resultSet.wasNull()) {
                this.setPassword(null);
            } else {
                this.setPassword((String)object);
            }
            object = resultSet.getString(COLNAME_DBURL);
            if (resultSet.wasNull()) {
                this.setDburl(null);
            } else {
                this.setDburl((String)object);
            }
            object = resultSet.getString(COLNAME_NAME);
            if (resultSet.wasNull()) {
                this.setName(null);
            } else {
                this.setName((String)object);
            }
            object = new ClobHelper(resultSet.getClob(COLNAME_NATIVE_SQL));
            if (resultSet.wasNull()) {
                this.setNativeSql((ClobHelper)null);
            } else {
                this.setNativeSql((ClobHelper)object);
            }
            object = resultSet.getString(COLNAME_STATUS);
            if (resultSet.wasNull()) {
                this.setStatus(null);
            } else {
                this.setStatus((String)object);
            }
            object = resultSet.getInt(COLNAME_NUM_CATALOGS);
            if (resultSet.wasNull()) {
                this.setNumCatalogs(null);
            } else {
                this.setNumCatalogs((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_COLUMNS);
            if (resultSet.wasNull()) {
                this.setNumColumns(null);
            } else {
                this.setNumColumns((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_CONSTRAINTS);
            if (resultSet.wasNull()) {
                this.setNumConstraints(null);
            } else {
                this.setNumConstraints((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_GROUPS);
            if (resultSet.wasNull()) {
                this.setNumGroups(null);
            } else {
                this.setNumGroups((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_ROLES);
            if (resultSet.wasNull()) {
                this.setNumRoles(null);
            } else {
                this.setNumRoles((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_INDEXES);
            if (resultSet.wasNull()) {
                this.setNumIndexes(null);
            } else {
                this.setNumIndexes((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_OTHER_OBJECTS);
            if (resultSet.wasNull()) {
                this.setNumOtherObjects(null);
            } else {
                this.setNumOtherObjects((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_PACKAGES);
            if (resultSet.wasNull()) {
                this.setNumPackages(null);
            } else {
                this.setNumPackages((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_PRIVILEGES);
            if (resultSet.wasNull()) {
                this.setNumPrivileges(null);
            } else {
                this.setNumPrivileges((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_SCHEMAS);
            if (resultSet.wasNull()) {
                this.setNumSchemas(null);
            } else {
                this.setNumSchemas((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_SEQUENCES);
            if (resultSet.wasNull()) {
                this.setNumSequences(null);
            } else {
                this.setNumSequences((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_STORED_PROGRAMS);
            if (resultSet.wasNull()) {
                this.setNumStoredPrograms(null);
            } else {
                this.setNumStoredPrograms((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_SYNONYMS);
            if (resultSet.wasNull()) {
                this.setNumSynonyms(null);
            } else {
                this.setNumSynonyms((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_TABLES);
            if (resultSet.wasNull()) {
                this.setNumTables(null);
            } else {
                this.setNumTables((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_TABLESPACES);
            if (resultSet.wasNull()) {
                this.setNumTablespaces(null);
            } else {
                this.setNumTablespaces((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_TRIGGERS);
            if (resultSet.wasNull()) {
                this.setNumTriggers(null);
            } else {
                this.setNumTriggers((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_USER_DEFINED_DATA_TYPES);
            if (resultSet.wasNull()) {
                this.setNumUserDefinedDataTypes(null);
            } else {
                this.setNumUserDefinedDataTypes((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_USERS);
            if (resultSet.wasNull()) {
                this.setNumUsers(null);
            } else {
                this.setNumUsers((Integer)object);
            }
            object = resultSet.getInt(COLNAME_NUM_VIEWS);
            if (resultSet.wasNull()) {
                this.setNumViews(null);
            } else {
                this.setNumViews((Integer)object);
            }
            object = resultSet.getString(COLNAME_COMMENTS);
            if (resultSet.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getObjectName() {
        return this.getName();
    }

    @Override
    public String getObjectNameFieldName() {
        return COLNAME_NAME;
    }

    public void rename(String string) {
        this.setName(string);
    }

    @Override
    public String getContainerFieldName() {
        return COLNAME_PROJECT_ID_FK;
    }

    @Override
    public DBObjectId getContainerId() {
        return this.getProjectId();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

