/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.util.RTreeJoinRes;

public class RTree
implements Serializable {
    protected int nDimensions;
    protected int nodeSize;
    protected int minFill;
    protected int nodeCount;
    protected int leafCount;
    protected int entryCount;
    protected int levels;
    protected Span[] mbh;
    protected TreeNode root;
    protected static double RTREE_TOL = 1.0E-24;
    protected double my_tolerance;

    public RTree(int n, int n2, int n3, double d) {
        this.nDimensions = n;
        this.nodeSize = n2;
        this.minFill = n3;
        this.nodeCount = 0;
        this.root = new TreeNode();
        this.levels = 0;
        this.entryCount = 0;
        this.leafCount = 1;
        this.mbh = new Span[this.nDimensions];
        this.my_tolerance = d;
    }

    public RTree(int n, int n2, int n3) {
        this.nDimensions = n;
        this.nodeSize = n2;
        this.minFill = n3;
        this.nodeCount = 0;
        this.root = new TreeNode();
        this.levels = 0;
        this.entryCount = 0;
        this.leafCount = 1;
        this.mbh = new Span[this.nDimensions];
        this.my_tolerance = RTREE_TOL;
    }

    public double[][] getMBH() {
        double[][] dArray = new double[this.nDimensions][2];
        for (int i = 0; i < this.nDimensions; ++i) {
            dArray[i][0] = this.mbh[i].min;
            dArray[i][1] = this.mbh[i].max;
        }
        return dArray;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public boolean search(double[][] dArray, ArrayList arrayList) {
        if (this.entryCount == 0) {
            return false;
        }
        boolean bl = false;
        Stack<StackEntry> stack = new Stack<StackEntry>();
        stack.ensureCapacity(this.levels * (this.nodeSize - 1));
        if (!this.overlapMBH(dArray, this.mbh)) {
            return false;
        }
        stack.push(new StackEntry(this.root, 0));
        while (!stack.isEmpty()) {
            int n;
            StackEntry stackEntry = (StackEntry)stack.pop();
            boolean bl2 = true;
            TreeNode treeNode = stackEntry.nP;
            for (int i = stackEntry.nodeLevel; i != this.levels; ++i) {
                bl2 = false;
                for (n = 0; n < treeNode.fillCount; ++n) {
                    if (!this.overlapMBH(dArray, treeNode.spans[n])) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) break;
                for (int j = n + 1; j < treeNode.fillCount; ++j) {
                    if (!this.overlapMBH(dArray, treeNode.spans[j])) continue;
                    stack.push(new StackEntry((TreeNode)treeNode.ptrs[j], i + 1));
                }
                treeNode = (TreeNode)treeNode.ptrs[n];
            }
            if (!bl2) continue;
            for (n = 0; n < treeNode.fillCount; ++n) {
                if (!this.overlapMBH(dArray, treeNode.spans[n])) continue;
                arrayList.add(treeNode.ptrs[n]);
                bl = true;
            }
        }
        return bl;
    }

    public void addEntry(double[][] dArray, Object object) {
        Span[] spanArray = new Span[this.nDimensions];
        for (int i = 0; i < this.nDimensions; ++i) {
            spanArray[i] = new Span(dArray[i][0], dArray[i][1]);
        }
        this.insertEntry(spanArray, object, this.levels);
        ++this.entryCount;
    }

    public boolean removeEntry(double[][] dArray, Object object) {
        int n;
        StackEntry stackEntry;
        Stack<StackEntry> stack = new Stack<StackEntry>();
        stack.ensureCapacity(this.levels * (this.nodeSize - 1));
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        TreeNode treeNode = null;
        Vector<TreeNode> vector = new Vector<TreeNode>(this.levels + 1);
        if (!this.overlapMBH(dArray, this.mbh)) {
            return false;
        }
        stack.push(new StackEntry(this.root, n2));
        while (!stack.isEmpty()) {
            stackEntry = (StackEntry)stack.pop();
            boolean bl2 = true;
            bl = false;
            vector.add(stackEntry.nodeLevel, stackEntry.nP);
            treeNode = stackEntry.nP;
            for (n2 = stackEntry.nodeLevel; n2 != this.levels; ++n2) {
                bl2 = false;
                for (n = 0; n < treeNode.fillCount; ++n) {
                    if (!this.overlapMBH(dArray, treeNode.spans[n])) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) break;
                for (int i = n + 1; i < treeNode.fillCount; ++i) {
                    if (!this.overlapMBH(dArray, treeNode.spans[i])) continue;
                    stack.push(new StackEntry((TreeNode)treeNode.ptrs[i], n2 + 1));
                }
                treeNode = (TreeNode)treeNode.ptrs[n];
                vector.add(n2 + 1, treeNode);
            }
            if (!bl2) continue;
            for (n = 0; n < treeNode.fillCount; ++n) {
                if (object != treeNode.ptrs[n]) continue;
                bl = true;
                n3 = n;
                break;
            }
            if (!bl) continue;
        }
        if (!bl) {
            return false;
        }
        --this.entryCount;
        stack.clear();
        boolean bl3 = true;
        while (true) {
            if (bl3) {
                if (n3 != treeNode.fillCount - 1) {
                    treeNode.spans[n3] = treeNode.spans[treeNode.fillCount - 1];
                    treeNode.ptrs[n3] = treeNode.ptrs[treeNode.fillCount - 1];
                }
                --treeNode.fillCount;
            }
            bl3 = false;
            if (treeNode == this.root) break;
            TreeNode treeNode2 = (TreeNode)vector.elementAt(n2 - 1);
            for (n = 0; n < treeNode2.fillCount && (TreeNode)treeNode2.ptrs[n] != treeNode; ++n) {
            }
            n3 = n;
            if (treeNode.fillCount < this.minFill) {
                bl3 = true;
                stack.push(new StackEntry(treeNode, n2));
            } else {
                treeNode2.spans[n3] = treeNode.bounds();
            }
            treeNode = treeNode2;
            --n2;
        }
        while (!stack.isEmpty()) {
            stackEntry = (StackEntry)stack.pop();
            for (n = 0; n < stackEntry.nP.fillCount; ++n) {
                this.insertEntry(stackEntry.nP.spans[n], stackEntry.nP.ptrs[n], stackEntry.nodeLevel);
            }
            if (stackEntry.nodeLevel != this.levels) continue;
            --this.leafCount;
        }
        this.mbh = this.root.bounds();
        while (this.levels != 0 && this.root.fillCount == 1) {
            this.root = (TreeNode)this.root.ptrs[0];
            --this.levels;
        }
        return true;
    }

    private TreeNode splitNode(TreeNode treeNode, Span[] spanArray, Object object) {
        int n;
        int n2;
        int n3;
        int n4;
        Span[] spanArray2 = new Span[this.nDimensions];
        Span[] spanArray3 = new Span[this.nDimensions];
        int[] nArray = new int[2 * this.nDimensions];
        for (n4 = 0; n4 < this.nDimensions; ++n4) {
            spanArray2[n4] = new Span(spanArray[n4].max, spanArray[n4].min);
            spanArray3[n4] = new Span(spanArray[n4]);
            nArray[2 * n4 + 1] = -1;
            nArray[2 * n4] = -1;
        }
        for (n4 = 0; n4 < this.nodeSize; ++n4) {
            for (int i = 0; i < this.nDimensions; ++i) {
                if (spanArray2[i].min > treeNode.spans[n4][i].max) {
                    spanArray2[i].min = treeNode.spans[n4][i].max;
                    nArray[2 * i] = n4;
                }
                if (spanArray2[i].max < treeNode.spans[n4][i].min) {
                    spanArray2[i].max = treeNode.spans[n4][i].min;
                    nArray[2 * i + 1] = n4;
                }
                if (spanArray3[i].min > treeNode.spans[n4][i].min) {
                    spanArray3[i].min = treeNode.spans[n4][i].min;
                }
                if (!(spanArray3[i].max < treeNode.spans[n4][i].max)) continue;
                spanArray3[i].max = treeNode.spans[n4][i].max;
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        int n5 = 0;
        boolean bl = true;
        for (n3 = 0; n3 < this.nDimensions; ++n3) {
            if (spanArray3[n3].max == spanArray3[n3].min) continue;
            if (bl) {
                bl = false;
                d = (spanArray2[n3].max - spanArray2[n3].min) / (spanArray3[n3].max - spanArray3[n3].min);
                n5 = n3;
                continue;
            }
            d2 = (spanArray2[n3].max - spanArray2[n3].min) / (spanArray3[n3].max - spanArray3[n3].min);
            if (!(d2 > d)) continue;
            d = d2;
            n5 = n3;
        }
        n3 = nArray[2 * n5];
        int n6 = nArray[2 * n5 + 1];
        if (n3 == n6) {
            --n6;
        }
        TreeNode treeNode2 = new TreeNode();
        TreeNode treeNode3 = new TreeNode();
        Span[] spanArray4 = new Span[this.nDimensions];
        Span[] spanArray5 = new Span[this.nDimensions];
        if (n6 >= 0) {
            treeNode2.spans[0] = treeNode.spans[n6];
            for (n2 = 0; n2 < this.nDimensions; ++n2) {
                spanArray4[n2] = new Span(treeNode.spans[n6][n2]);
            }
            treeNode2.ptrs[0] = treeNode.ptrs[n6];
        } else {
            treeNode2.spans[0] = spanArray;
            for (n2 = 0; n2 < this.nDimensions; ++n2) {
                spanArray4[n2] = new Span(spanArray[n2]);
            }
            treeNode2.ptrs[0] = object;
        }
        treeNode2.fillCount = 1;
        if (n3 >= 0) {
            treeNode3.spans[0] = treeNode.spans[n3];
            for (n2 = 0; n2 < this.nDimensions; ++n2) {
                spanArray5[n2] = new Span(treeNode.spans[n3][n2]);
            }
            treeNode3.ptrs[0] = treeNode.ptrs[n3];
        } else {
            treeNode3.spans[0] = spanArray;
            for (n2 = 0; n2 < this.nDimensions; ++n2) {
                spanArray5[n2] = new Span(spanArray[n2]);
            }
            treeNode3.ptrs[0] = object;
        }
        treeNode3.fillCount = 1;
        n2 = this.nodeSize - 1;
        for (n = -1; n < this.nodeSize; ++n) {
            TreeNode treeNode4;
            if (n == n3 || n == n6) continue;
            if (n2 + treeNode2.fillCount == this.minFill) {
                treeNode4 = treeNode2;
            } else if (n2 + treeNode3.fillCount == this.minFill) {
                treeNode4 = treeNode3;
            } else if (n == -1) {
                if (this.volumeDiff(spanArray4, spanArray) < this.volumeDiff(spanArray5, spanArray)) {
                    this.growMBH(spanArray4, spanArray);
                    treeNode4 = treeNode2;
                } else {
                    this.growMBH(spanArray5, spanArray);
                    treeNode4 = treeNode3;
                }
            } else if (this.volumeDiff(spanArray4, treeNode.spans[n]) < this.volumeDiff(spanArray5, treeNode.spans[n])) {
                this.growMBH(spanArray4, treeNode.spans[n]);
                treeNode4 = treeNode2;
            } else {
                this.growMBH(spanArray5, treeNode.spans[n]);
                treeNode4 = treeNode3;
            }
            --n2;
            if (n >= 0) {
                treeNode4.spans[treeNode4.fillCount] = treeNode.spans[n];
                treeNode4.ptrs[treeNode4.fillCount] = treeNode.ptrs[n];
            } else {
                treeNode4.spans[treeNode4.fillCount] = spanArray;
                treeNode4.ptrs[treeNode4.fillCount] = object;
            }
            ++treeNode4.fillCount;
        }
        treeNode.fillCount = treeNode3.fillCount;
        for (n = 0; n < treeNode.fillCount; ++n) {
            treeNode.ptrs[n] = treeNode3.ptrs[n];
            treeNode.spans[n] = treeNode3.spans[n];
        }
        --this.nodeCount;
        return treeNode2;
    }

    private void insertEntry(Span[] spanArray, Object object, int n) {
        Span[] spanArray2;
        int n2;
        int n3;
        TreeNode[] treeNodeArray = new TreeNode[this.levels];
        int n4 = -1;
        TreeNode treeNode = this.root;
        int n5 = 0;
        Span span = new Span();
        TreeNode treeNode2 = null;
        boolean bl = false;
        for (n3 = 0; n3 < n; ++n3) {
            treeNodeArray[++n4] = treeNode;
            double d = -1.0;
            for (n2 = 0; n2 < treeNode.fillCount; ++n2) {
                double d2 = 1.0;
                double d3 = 1.0;
                for (int i = 0; i < this.nDimensions; ++i) {
                    span = treeNode.spans[n2][i];
                    double d4 = span.max - span.min;
                    d2 *= d4;
                    double d5 = d4;
                    if (spanArray[i].max - span.max > 0.0) {
                        d5 += spanArray[i].max - span.max;
                    }
                    if (spanArray[i].min - span.min < 0.0) {
                        d5 += span.min - spanArray[i].min;
                    }
                    d3 *= d5;
                }
                if (!(d3 - d2 < d) && !(d < 0.0)) continue;
                d = d3 - d2;
                n5 = n2;
            }
            treeNode = (TreeNode)treeNode.ptrs[n5];
        }
        if (treeNode.fillCount < this.nodeSize) {
            treeNode.ptrs[treeNode.fillCount] = object;
            treeNode.spans[treeNode.fillCount] = spanArray;
            ++treeNode.fillCount;
        } else {
            bl = true;
            treeNode2 = this.splitNode(treeNode, spanArray, object);
            if (n3 == this.levels) {
                ++this.leafCount;
            }
        }
        TreeNode treeNode3 = treeNode;
        while (n3 > 0) {
            --n3;
            treeNode = treeNodeArray[n4--];
            for (n2 = 0; n2 < treeNode.fillCount && (TreeNode)treeNode.ptrs[n2] != treeNode3; ++n2) {
            }
            spanArray2 = treeNode3.bounds();
            treeNode.spans[n2] = spanArray2;
            if (bl) {
                bl = false;
                spanArray2 = treeNode2.bounds();
                if (treeNode.fillCount < this.nodeSize) {
                    treeNode.ptrs[treeNode.fillCount] = treeNode2;
                    treeNode.spans[treeNode.fillCount] = spanArray2;
                    ++treeNode.fillCount;
                } else {
                    bl = true;
                    treeNode2 = this.splitNode(treeNode, spanArray2, treeNode2);
                }
            }
            treeNode3 = treeNode;
        }
        if (bl) {
            this.root = new TreeNode();
            this.root.fillCount = 2;
            spanArray2 = treeNode3.bounds();
            this.root.ptrs[0] = treeNode;
            this.root.spans[0] = spanArray2;
            spanArray2 = treeNode2.bounds();
            this.root.ptrs[1] = treeNode2;
            this.root.spans[1] = spanArray2;
            ++this.levels;
        }
        this.mbh = this.root.bounds();
    }

    public void packTree(double[][][] dArray, Object[] objectArray) throws Exception {
        Span[] spanArray;
        int n;
        int n2;
        if (dArray.length != objectArray.length) {
            throw new Exception("Length mismatch between mbh and object list");
        }
        int n3 = objectArray.length;
        if (n3 == 0) {
            return;
        }
        Int[] intArray = new Int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            intArray[n2] = new Int();
        }
        n2 = (int)(1.1 * ((double)n3 / (double)(this.nodeSize - 1) + Math.pow((double)n3 / (double)this.nodeSize, (double)(this.nDimensions - 1) / (double)this.nDimensions)));
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        boolean bl = true;
        this.nodeCount = 0;
        this.root = new TreeNode();
        this.levels = 0;
        this.leafCount = 1;
        this.entryCount = n3;
        if (n3 <= this.nodeSize) {
            this.root.fillCount = n3;
            for (int i = 0; i < n3; ++i) {
                this.root.ptrs[i] = objectArray[i];
                this.root.spans[i] = new Span[this.nDimensions];
                for (int j = 0; j < this.nDimensions; ++j) {
                    this.root.spans[i][j] = new Span(dArray[i][j][0], dArray[i][j][1]);
                }
            }
            this.mbh = this.root.bounds();
            return;
        }
        while (n3 > this.nodeSize) {
            ++this.levels;
            for (n = 0; n < n3; ++n) {
                intArray[n].integer = n;
            }
            n3 = this.recursiveSubSort(intArray, 0, n3, 0, n3, dArray, objectArray, arrayList, 0);
            if (bl) {
                bl = false;
                this.leafCount = n3;
            }
            for (n = 0; n < n3; ++n) {
                spanArray = ((TreeNode)arrayList.get(n)).bounds();
                objectArray[n] = arrayList.get(n);
                for (int i = 0; i < this.nDimensions; ++i) {
                    dArray[n][i][0] = spanArray[i].min;
                    dArray[n][i][1] = spanArray[i].max;
                }
            }
        }
        this.root.fillCount = n3;
        for (n = 0; n < n3; ++n) {
            spanArray = ((TreeNode)arrayList.get(n)).bounds();
            this.root.ptrs[n] = arrayList.get(n);
            this.root.spans[n] = spanArray;
        }
        this.mbh = this.root.bounds();
    }

    private int recursiveSubSort(Int[] intArray, int n, int n2, int n3, int n4, double[][][] dArray, Object[] objectArray, ArrayList<Object> arrayList, int n5) {
        int n6 = n2 - n;
        ComparatorImpl comparatorImpl = new ComparatorImpl(dArray, n3);
        Arrays.sort(intArray, n, n2, comparatorImpl);
        n2 = n;
        if (n3 + 1 == this.nDimensions) {
            while (n6 > 0) {
                TreeNode treeNode = new TreeNode();
                arrayList.add(++n5 - 1, treeNode);
                treeNode.fillCount = n6 > this.nodeSize ? this.nodeSize : n6;
                n6 -= this.nodeSize;
                n = n2;
                n2 = n + treeNode.fillCount;
                int n7 = 0;
                for (int i = n; i < n2; ++i) {
                    treeNode.ptrs[n7] = objectArray[intArray[i].integer];
                    treeNode.spans[n7] = new Span[this.nDimensions];
                    for (int j = 0; j < this.nDimensions; ++j) {
                        treeNode.spans[n7][j] = new Span(dArray[intArray[i].integer][j][0], dArray[intArray[i].integer][j][1]);
                    }
                    ++n7;
                }
            }
            return n5;
        }
        int n8 = (int)((double)n4 * Math.pow((double)this.nodeSize / (double)n4, (double)(n3 + 1) / (double)this.nDimensions) + 0.5);
        while (n6 > 0) {
            n = n2;
            int n9 = n6 > n8 ? n8 : n6;
            n2 = n + n9;
            n6 -= n8;
            n5 = this.recursiveSubSort(intArray, n, n2, n3 + 1, n4, dArray, objectArray, arrayList, n5);
        }
        return n5;
    }

    private void growMBH(Span[] spanArray, Span[] spanArray2) {
        for (int i = 0; i < this.nDimensions; ++i) {
            if (spanArray2[i].min < spanArray[i].min) {
                spanArray[i].min = spanArray2[i].min;
            }
            if (!(spanArray2[i].max > spanArray[i].max)) continue;
            spanArray[i].max = spanArray2[i].max;
        }
    }

    private double volume(Span[] spanArray) {
        double d = 1.0;
        for (int i = 0; i < this.nDimensions; ++i) {
            d *= spanArray[i].max - spanArray[i].min;
        }
        return d;
    }

    private double volumeDiff(Span[] spanArray, Span[] spanArray2) {
        Span[] spanArray3 = new Span[this.nDimensions];
        for (int i = 0; i < this.nDimensions; ++i) {
            spanArray3[i] = new Span(spanArray[i]);
        }
        this.growMBH(spanArray3, spanArray2);
        return this.volume(spanArray3) - this.volume(spanArray);
    }

    private boolean overlapMBH(double[][] dArray, Span[] spanArray) {
        return this.overlapMBH(dArray, spanArray, this.my_tolerance);
    }

    private boolean overlapMBH(double[][] dArray, Span[] spanArray, double d) {
        for (int i = 0; i < this.nDimensions; ++i) {
            if (!(dArray[i][0] > spanArray[i].max + d) && !(dArray[i][1] + d < spanArray[i].min)) continue;
            return false;
        }
        return true;
    }

    public boolean intscts(Span[] spanArray, Span[] spanArray2) {
        return this.intscts(spanArray, spanArray2, this.my_tolerance);
    }

    public boolean intscts(Span[] spanArray, Span[] spanArray2, double d) {
        for (int i = 0; i < this.nDimensions; ++i) {
            if (!(spanArray[i].min > spanArray2[i].max + d) && !(spanArray2[i].min > spanArray[i].max + d)) continue;
            return false;
        }
        return true;
    }

    public double compMinDistance(Span[] spanArray, Span[] spanArray2) {
        return this.compMinDistance(spanArray, spanArray2, this.my_tolerance);
    }

    public double compMinDistance(Span[] spanArray, Span[] spanArray2, double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.nDimensions; ++i) {
            double d3 = spanArray[i].min <= spanArray2[i].max + d && spanArray2[i].min <= spanArray[i].max + d ? 0.0 : (spanArray[i].min > spanArray2[i].max ? spanArray[i].min - spanArray2[i].max : spanArray2[i].min - spanArray[i].max);
            d2 += d3 * d3;
        }
        return Math.sqrt(d2);
    }

    public void compIntsxn(Span[] spanArray, Span[] spanArray2, Span[] spanArray3) {
        for (int i = 0; i < this.nDimensions; ++i) {
            spanArray3[i] = new Span(Math.max(spanArray[i].min, spanArray2[i].min), Math.min(spanArray[i].max, spanArray2[i].max));
        }
    }

    public double compArea(Span[] spanArray) {
        double d = 1.0;
        for (int i = 0; i < this.nDimensions; ++i) {
            double d2 = spanArray[i].max - spanArray[i].min;
            d *= d2;
        }
        return d;
    }

    public boolean anyInteract(RTree rTree, ArrayList arrayList) throws Exception {
        return this.anyInteract(rTree, false, true, arrayList);
    }

    public boolean anyInteract(RTree rTree, boolean bl, boolean bl2, ArrayList arrayList) throws Exception {
        return this.anyInteract(rTree, bl, bl2, arrayList, false);
    }

    public boolean anyInteract(RTree rTree, boolean bl, boolean bl2, ArrayList arrayList, boolean bl3) throws Exception {
        boolean bl4 = false;
        JoinEntryCmp joinEntryCmp = new JoinEntryCmp(false);
        if (rTree.root == null || this.root == null || rTree.nDimensions != this.nDimensions || rTree.entryCount == 0 || this.entryCount == 0) {
            return false;
        }
        if (!this.intscts(rTree.mbh, this.mbh, this.nDimensions)) {
            return false;
        }
        if (rTree.entryCount == 0 || this.entryCount == 0) {
            return false;
        }
        if (this.levels > rTree.levels) {
            return rTree.anyInteract(this, bl, bl2, arrayList, true);
        }
        Span[] spanArray = new Span[this.nDimensions];
        this.compIntsxn(rTree.mbh, this.mbh, spanArray);
        Stack<JoinEntry> stack = new Stack<JoinEntry>();
        stack.push(new JoinEntry(this.root, rTree.root, this.levels, rTree.levels, spanArray, this.volume(spanArray)));
        while (!stack.empty()) {
            Span[] spanArray2;
            int n;
            JoinEntry joinEntry = (JoinEntry)stack.pop();
            TreeNode treeNode = (TreeNode)joinEntry.rtree1Obj;
            TreeNode treeNode2 = (TreeNode)joinEntry.rtree2Obj;
            ArrayList<JoinEntry> arrayList2 = new ArrayList<JoinEntry>(30);
            if (joinEntry.rtree1Level == 0 && joinEntry.rtree2Level == 0) {
                for (n = 0; n < treeNode.fillCount; ++n) {
                    if (!this.intscts(treeNode.spans[n], spanArray, this.my_tolerance)) continue;
                    for (int i = 0; i < treeNode2.fillCount; ++i) {
                        if (!this.intscts(treeNode2.spans[i], spanArray, this.my_tolerance) || !this.intscts(treeNode.spans[n], treeNode2.spans[i], this.my_tolerance)) continue;
                        Span[] spanArray3 = new Span[this.nDimensions];
                        this.compIntsxn(treeNode.spans[n], treeNode2.spans[i], spanArray3);
                        arrayList2.add(new JoinEntry(treeNode.ptrs[n], treeNode2.ptrs[i], -1, -1, spanArray3, this.volume(spanArray3)));
                    }
                }
                if (!bl2) {
                    Collections.sort(arrayList2, joinEntryCmp);
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    boolean bl5;
                    spanArray2 = (Span[])arrayList2.get(i);
                    boolean bl6 = bl5 = !bl;
                    if (bl) {
                        J3D_Geometry j3D_Geometry = (J3D_Geometry)spanArray2.rtree1Obj;
                        J3D_Geometry j3D_Geometry2 = (J3D_Geometry)spanArray2.rtree2Obj;
                        boolean[] blArray = new boolean[2];
                        boolean[] blArray2 = new boolean[2];
                        boolean[] blArray3 = new boolean[2];
                        j3D_Geometry.getFlags(j3D_Geometry2, blArray, blArray2, blArray3);
                        if (j3D_Geometry.anyInteract2(j3D_Geometry2, blArray, blArray2, blArray3, this.my_tolerance)) {
                            bl5 = true;
                        }
                    }
                    if (!bl5) continue;
                    if (!bl3) {
                        arrayList.add(new RTreeJoinRes(spanArray2.rtree1Obj, spanArray2.rtree2Obj));
                    } else {
                        arrayList.add(new RTreeJoinRes(spanArray2.rtree2Obj, spanArray2.rtree1Obj));
                    }
                    if (bl2) continue;
                    return true;
                }
                continue;
            }
            if (joinEntry.rtree1Level == 0 && joinEntry.rtree2Level > 0) {
                int n2;
                Span[] spanArray4 = treeNode.bounds();
                for (n2 = 0; n2 < treeNode2.fillCount; ++n2) {
                    if (!this.intscts(treeNode2.spans[n2], spanArray, this.my_tolerance) || !this.intscts(spanArray4, treeNode2.spans[n2], this.my_tolerance)) continue;
                    Span[] spanArray5 = new Span[this.nDimensions];
                    this.compIntsxn(spanArray4, treeNode2.spans[n2], spanArray5);
                    arrayList2.add(new JoinEntry(treeNode, treeNode2.ptrs[n2], joinEntry.rtree1Level, joinEntry.rtree2Level - 1, spanArray5, this.volume(spanArray5)));
                }
                for (n2 = arrayList2.size() - 1; n2 >= 0; --n2) {
                    stack.push((JoinEntry)arrayList2.get(n2));
                }
                continue;
            }
            for (n = 0; n < treeNode.fillCount; ++n) {
                Span[] spanArray6 = treeNode.bounds();
                if (!this.intscts(treeNode.spans[n], spanArray, this.my_tolerance)) continue;
                for (int i = 0; i < treeNode2.fillCount; ++i) {
                    if (!this.intscts(treeNode2.spans[i], spanArray, this.my_tolerance) || !this.intscts(treeNode.spans[n], treeNode2.spans[i], this.my_tolerance)) continue;
                    spanArray2 = new Span[this.nDimensions];
                    this.compIntsxn(treeNode.spans[n], treeNode2.spans[i], spanArray2);
                    arrayList2.add(new JoinEntry(treeNode.ptrs[n], treeNode2.ptrs[i], joinEntry.rtree1Level - 1, joinEntry.rtree2Level - 1, spanArray2, this.volume(spanArray2)));
                }
            }
            for (n = arrayList2.size() - 1; n >= 0; --n) {
                stack.push((JoinEntry)arrayList2.get(n));
            }
        }
        return arrayList.size() > 0;
    }

    public boolean anyInteract(boolean bl, boolean bl2, ArrayList arrayList, boolean bl3) throws Exception {
        boolean bl4 = true;
        return this.panyinteract(bl, bl2, arrayList, bl3, bl4);
    }

    private boolean panyinteract(boolean bl, boolean bl2, ArrayList arrayList, boolean bl3, boolean bl4) throws Exception {
        boolean bl5 = false;
        JoinEntryCmp joinEntryCmp = new JoinEntryCmp(false);
        RTree rTree = this;
        if (rTree.root == null || this.root == null || rTree.nDimensions != this.nDimensions || rTree.entryCount == 0 || this.entryCount == 0) {
            return false;
        }
        if (!this.intscts(rTree.mbh, this.mbh, this.nDimensions)) {
            return false;
        }
        if (rTree.entryCount == 0 || this.entryCount == 0) {
            return false;
        }
        if (this.levels > rTree.levels) {
            return rTree.anyInteract(this, bl, bl2, arrayList, true);
        }
        Span[] spanArray = new Span[this.nDimensions];
        this.compIntsxn(rTree.mbh, this.mbh, spanArray);
        Stack<JoinEntry> stack = new Stack<JoinEntry>();
        stack.push(new JoinEntry(this.root, rTree.root, this.levels, rTree.levels, spanArray, this.volume(spanArray)));
        while (!stack.empty()) {
            Span[] spanArray2;
            int n;
            JoinEntry joinEntry = (JoinEntry)stack.pop();
            TreeNode treeNode = (TreeNode)joinEntry.rtree1Obj;
            TreeNode treeNode2 = (TreeNode)joinEntry.rtree2Obj;
            ArrayList<JoinEntry> arrayList2 = new ArrayList<JoinEntry>(30);
            if (joinEntry.rtree1Level == 0 && joinEntry.rtree2Level == 0) {
                for (n = 0; n < treeNode.fillCount; ++n) {
                    if (!this.intscts(treeNode.spans[n], spanArray, this.my_tolerance)) continue;
                    for (int i = 0; i < treeNode2.fillCount; ++i) {
                        if (!this.intscts(treeNode2.spans[i], spanArray, this.my_tolerance) || !this.intscts(treeNode.spans[n], treeNode2.spans[i], this.my_tolerance)) continue;
                        Span[] spanArray3 = new Span[this.nDimensions];
                        this.compIntsxn(treeNode.spans[n], treeNode2.spans[i], spanArray3);
                        arrayList2.add(new JoinEntry(treeNode.ptrs[n], treeNode2.ptrs[i], -1, -1, spanArray3, this.volume(spanArray3)));
                    }
                }
                if (!bl2) {
                    Collections.sort(arrayList2, joinEntryCmp);
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ArrayList arrayList3;
                    Object object;
                    J3D_Geometry j3D_Geometry;
                    J3D_Geometry j3D_Geometry2;
                    J3D_Geometry j3D_Geometry3;
                    J3D_Geometry j3D_Geometry4;
                    boolean bl6;
                    spanArray2 = (Span[])arrayList2.get(i);
                    boolean bl7 = bl6 = !bl;
                    if (bl) {
                        j3D_Geometry4 = null;
                        j3D_Geometry3 = null;
                        if (!bl4) {
                            j3D_Geometry4 = (J3D_Geometry)spanArray2.rtree1Obj;
                            j3D_Geometry3 = (J3D_Geometry)spanArray2.rtree2Obj;
                        } else {
                            j3D_Geometry2 = new Object[3];
                            j3D_Geometry = new Object[3];
                            j3D_Geometry2 = (Object[])spanArray2.rtree1Obj;
                            j3D_Geometry = (Object[])spanArray2.rtree2Obj;
                            j3D_Geometry4 = (J3D_Geometry)j3D_Geometry2[0];
                            j3D_Geometry3 = (J3D_Geometry)j3D_Geometry[0];
                            object = new ArrayList();
                            arrayList3 = new ArrayList();
                            object = (ArrayList)j3D_Geometry2[1];
                            arrayList3 = (ArrayList)j3D_Geometry[1];
                            int n2 = (Integer)j3D_Geometry2[2];
                            int n3 = (Integer)j3D_Geometry[2];
                        }
                        j3D_Geometry2 = (J3D_Geometry)new boolean[2];
                        j3D_Geometry = (J3D_Geometry)new boolean[2];
                        object = new boolean[2];
                        j3D_Geometry4.getFlags(j3D_Geometry3, (boolean[])j3D_Geometry2, (boolean[])j3D_Geometry, (boolean[])object);
                        if (j3D_Geometry4.anyInteract2(j3D_Geometry3, (boolean[])j3D_Geometry2, (boolean[])j3D_Geometry, (boolean[])object, this.my_tolerance)) {
                            bl6 = true;
                        }
                    }
                    if (!bl6) continue;
                    j3D_Geometry4 = new Object[3];
                    j3D_Geometry3 = new Object[3];
                    j3D_Geometry4 = (J3D_Geometry)spanArray2.rtree1Obj;
                    j3D_Geometry3 = (J3D_Geometry)spanArray2.rtree2Obj;
                    j3D_Geometry2 = (J3D_Geometry)j3D_Geometry4[0];
                    j3D_Geometry = (J3D_Geometry)j3D_Geometry3[0];
                    object = new ArrayList();
                    arrayList3 = new ArrayList();
                    object = (ArrayList)j3D_Geometry4[1];
                    arrayList3 = (ArrayList)j3D_Geometry3[1];
                    if (j3D_Geometry2 == j3D_Geometry && ((ArrayList)object).equals(arrayList3) && bl4) continue;
                    if (!bl3) {
                        arrayList.add(new RTreeJoinRes(spanArray2.rtree1Obj, spanArray2.rtree2Obj));
                    } else {
                        arrayList.add(new RTreeJoinRes(spanArray2.rtree2Obj, spanArray2.rtree1Obj));
                    }
                    if (bl2) continue;
                    return true;
                }
                continue;
            }
            if (joinEntry.rtree1Level == 0 && joinEntry.rtree2Level > 0) {
                int n4;
                Span[] spanArray4 = treeNode.bounds();
                for (n4 = 0; n4 < treeNode2.fillCount; ++n4) {
                    if (!this.intscts(treeNode2.spans[n4], spanArray, this.my_tolerance) || !this.intscts(spanArray4, treeNode2.spans[n4], this.my_tolerance)) continue;
                    Span[] spanArray5 = new Span[this.nDimensions];
                    this.compIntsxn(spanArray4, treeNode2.spans[n4], spanArray5);
                    arrayList2.add(new JoinEntry(treeNode, treeNode2.ptrs[n4], joinEntry.rtree1Level, joinEntry.rtree2Level - 1, spanArray5, this.volume(spanArray5)));
                }
                for (n4 = arrayList2.size() - 1; n4 >= 0; --n4) {
                    stack.push((JoinEntry)arrayList2.get(n4));
                }
                continue;
            }
            for (n = 0; n < treeNode.fillCount; ++n) {
                Span[] spanArray6 = treeNode.bounds();
                if (!this.intscts(treeNode.spans[n], spanArray, this.my_tolerance)) continue;
                for (int i = 0; i < treeNode2.fillCount; ++i) {
                    if (!this.intscts(treeNode2.spans[i], spanArray, this.my_tolerance) || !this.intscts(treeNode.spans[n], treeNode2.spans[i], this.my_tolerance)) continue;
                    spanArray2 = new Span[this.nDimensions];
                    this.compIntsxn(treeNode.spans[n], treeNode2.spans[i], spanArray2);
                    arrayList2.add(new JoinEntry(treeNode.ptrs[n], treeNode2.ptrs[i], joinEntry.rtree1Level - 1, joinEntry.rtree2Level - 1, spanArray2, this.volume(spanArray2)));
                }
            }
            for (n = arrayList2.size() - 1; n >= 0; --n) {
                stack.push((JoinEntry)arrayList2.get(n));
            }
        }
        return arrayList.size() > 0;
    }

    public boolean nnSearch(double[][] dArray, ArrayList arrayList) throws Exception {
        RTree rTree = new RTree(2, 8, 2);
        rTree.addEntry(dArray, dArray);
        return this.nnSearch(rTree, false, false, arrayList);
    }

    public boolean nnSearch(RTree rTree, boolean bl, boolean bl2, ArrayList arrayList) throws Exception {
        return this.nnSearch(rTree, bl, bl2, arrayList, false);
    }

    public boolean nnSearch(RTree rTree, boolean bl, boolean bl2, ArrayList arrayList, boolean bl3) throws Exception {
        boolean bl4 = false;
        if (rTree.entryCount == 0 || this.entryCount == 0) {
            return false;
        }
        if (this.levels > rTree.levels) {
            return rTree.nnSearch(this, bl, bl2, arrayList, true);
        }
        MyPriorityQueue myPriorityQueue = new MyPriorityQueue(new JoinEntryCmp(true));
        double d = Double.MAX_VALUE;
        myPriorityQueue.add(new JoinEntry(this.root, rTree.root, this.levels, rTree.levels, Double.MAX_VALUE));
        while (myPriorityQueue.size() > 0) {
            TreeNode treeNode;
            Span[] spanArray;
            JoinEntry joinEntry = (JoinEntry)myPriorityQueue.poll();
            if (joinEntry.entryValue < Double.MAX_VALUE && (!bl2 ? joinEntry.entryValue >= d : joinEntry.entryValue > d)) break;
            if (joinEntry.rtree1Level == -2 && joinEntry.rtree2Level == -2) {
                double d2 = joinEntry.entryValue;
                if (!bl3) {
                    arrayList.add(new RTreeJoinRes(joinEntry.rtree1Obj, joinEntry.rtree2Obj, d2));
                } else {
                    arrayList.add(new RTreeJoinRes(joinEntry.rtree2Obj, joinEntry.rtree1Obj, d2));
                }
                bl4 = true;
                d = d2;
                if (bl2) continue;
                break;
            }
            if (joinEntry.rtree1Level == -1 && joinEntry.rtree2Level == -1) {
                double d3 = joinEntry.entryValue;
                if (d3 > d) continue;
                if (bl) {
                    spanArray = (Span[])joinEntry.rtree1Obj;
                    J3D_Geometry j3D_Geometry = (J3D_Geometry)joinEntry.rtree2Obj;
                    boolean[] blArray = new boolean[2];
                    boolean[] blArray2 = new boolean[2];
                    boolean[] blArray3 = new boolean[2];
                    blArray[0] = false;
                    blArray[1] = false;
                    blArray2[0] = false;
                    blArray2[1] = false;
                    blArray3[0] = false;
                    blArray3[1] = false;
                    double[] dArray = new double[6];
                    dArray = spanArray.distCpa2(j3D_Geometry, blArray, blArray2, blArray3, this.my_tolerance, "FALSE");
                    d3 = Math.sqrt((dArray[0] - dArray[3]) * (dArray[0] - dArray[3]) + (dArray[1] - dArray[4]) * (dArray[1] - dArray[4]) + (dArray[2] - dArray[5]) * (dArray[2] - dArray[5]));
                    int[] nArray = new int[3];
                    double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2]};
                    nArray[0] = 1;
                    nArray[1] = 1;
                    nArray[2] = 1;
                    J3D_Geometry j3D_Geometry2 = new J3D_Geometry(1, 0, nArray, dArray2);
                    int[] nArray2 = new int[3];
                    double[] dArray3 = new double[]{dArray[3], dArray[4], dArray[5]};
                    nArray2[0] = 1;
                    nArray2[1] = 1;
                    nArray2[2] = 1;
                    J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, 0, nArray2, dArray3);
                    j3D_Geometry2.setBelongingGeometry(spanArray.getBelongingGeometry());
                    j3D_Geometry3.setBelongingGeometry(j3D_Geometry.getBelongingGeometry());
                    myPriorityQueue.add(new JoinEntry(j3D_Geometry2, j3D_Geometry3, joinEntry.rtree1Level - 1, joinEntry.rtree2Level - 1, d3));
                    continue;
                }
                if (!bl3) {
                    arrayList.add(new RTreeJoinRes(joinEntry.rtree1Obj, joinEntry.rtree2Obj, d3));
                } else {
                    arrayList.add(new RTreeJoinRes(joinEntry.rtree2Obj, joinEntry.rtree1Obj, d3));
                }
                bl4 = true;
                d = d3;
                if (bl2) continue;
                break;
            }
            if (joinEntry.rtree1Level == 0 && joinEntry.rtree2Level == 0 || joinEntry.rtree1Level > 0 && joinEntry.rtree2Level > 0) {
                TreeNode treeNode2 = (TreeNode)joinEntry.rtree1Obj;
                treeNode = (TreeNode)joinEntry.rtree2Obj;
                for (int i = 0; i < treeNode2.fillCount; ++i) {
                    for (int j = 0; j < treeNode.fillCount; ++j) {
                        double d4 = this.compMinDistance(treeNode2.spans[i], treeNode.spans[j]);
                        if (d4 > d) continue;
                        myPriorityQueue.add(new JoinEntry(treeNode2.ptrs[i], treeNode.ptrs[j], joinEntry.rtree1Level - 1, joinEntry.rtree2Level - 1, d4));
                    }
                }
                continue;
            }
            TreeNode treeNode3 = (TreeNode)joinEntry.rtree1Obj;
            treeNode = (TreeNode)joinEntry.rtree2Obj;
            spanArray = treeNode3.bounds();
            for (int i = 0; i < treeNode.fillCount; ++i) {
                double d5 = this.compMinDistance(spanArray, treeNode.spans[i]);
                if (d5 > d) continue;
                myPriorityQueue.add(new JoinEntry(treeNode3, treeNode.ptrs[i], joinEntry.rtree1Level, joinEntry.rtree2Level - 1, d5));
            }
        }
        return bl4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] stringArray) throws IOException, Exception {
        int n;
        int n2;
        RTree rTree = new RTree(2, 8, 2);
        Random random = new Random(104729L);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("input number of random entries to generate");
        String string = bufferedReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        double[][][] dArrayArray = new double[n3][][];
        double[][][] dArrayArray2 = new double[n3][][];
        Object[] objectArray = new Object[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArrayArray[n2] = new double[2][];
            dArrayArray2[n2] = new double[2][];
            dArrayArray[n2][0] = new double[2];
            dArrayArray2[n2][0] = new double[2];
            double d = random.nextDouble();
            dArrayArray[n2][0][1] = d;
            dArrayArray[n2][0][0] = d;
            dArrayArray2[n2][0][1] = d;
            dArrayArray2[n2][0][0] = d;
            dArrayArray[n2][1] = new double[2];
            dArrayArray2[n2][1] = new double[2];
            double d2 = random.nextDouble();
            dArrayArray[n2][1][1] = d2;
            dArrayArray[n2][1][0] = d2;
            dArrayArray2[n2][1][1] = d2;
            dArrayArray2[n2][1][0] = d2;
            objectArray[n2] = dArrayArray2[n2];
        }
        n2 = 0;
        System.out.print("Input tree build method (0=pack tree; 1=one-at-a-time) : ");
        string = bufferedReader.readLine();
        stringTokenizer = new StringTokenizer(string);
        n2 = Integer.parseInt(stringTokenizer.nextToken());
        switch (n2) {
            case 1: {
                long l = System.currentTimeMillis();
                for (n = 0; n < objectArray.length; ++n) {
                    rTree.addEntry(dArrayArray[n], objectArray[n]);
                }
                System.out.println("one_at_a_time elapsed time: " + (System.currentTimeMillis() - l) / 1000L + " seconds");
                break;
            }
            default: {
                long l = System.currentTimeMillis();
                rTree.packTree(dArrayArray, objectArray);
                System.out.println("STR pack tree elapsed time: " + (System.currentTimeMillis() - l) / 1000L + " seconds");
            }
        }
        n = 0;
        double[][] dArrayArray3 = new double[][]{new double[2], new double[2]};
        ArrayList arrayList = new ArrayList(100);
        block15: while (true) {
            System.out.print("input operation (0=exit; 1=srch; 2=insrt; 3=inspect; 4-remove; 5-plot, 6-join, 7-nn) : ");
            string = bufferedReader.readLine();
            stringTokenizer = new StringTokenizer(string);
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            switch (n2) {
                case 0: {
                    break block15;
                }
                case 1: {
                    System.out.println("Input search mbr - xmin, xmax, ymin, ymax");
                    string = bufferedReader.readLine();
                    stringTokenizer = new StringTokenizer(string);
                    dArrayArray3[0][0] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray3[0][1] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray3[1][0] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray3[1][1] = Double.parseDouble(stringTokenizer.nextToken());
                    arrayList.clear();
                    n = rTree.search(dArrayArray3, arrayList) ? 1 : 0;
                    if (n != 0) {
                        System.out.println("returned from search xmin, xmax, ymin, ymax");
                        for (int i = 0; i < arrayList.size(); ++i) {
                            double[][] dArray = (double[][])arrayList.get(i);
                            System.out.println(dArray[0][0] + " " + dArray[0][1] + " " + dArray[1][0] + " " + dArray[1][1]);
                        }
                        break;
                    } else {
                        System.out.println("null search result");
                        break;
                    }
                }
                case 2: {
                    System.out.println("Input insert mbr - xmin, xmax, ymin, ymax");
                    string = bufferedReader.readLine();
                    stringTokenizer = new StringTokenizer(string);
                    double[][] dArrayArray4 = new double[][]{new double[2], new double[2]};
                    dArrayArray4[0][0] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray4[0][1] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray4[1][0] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray4[1][1] = Double.parseDouble(stringTokenizer.nextToken());
                    rTree.addEntry(dArrayArray4, dArrayArray4);
                    break;
                }
                case 3: {
                    System.out.println("nodeCount: " + rTree.nodeCount + "  leafCount: " + rTree.leafCount + "  entryCount: " + rTree.entryCount + "  num levels: " + rTree.levels);
                    System.out.println("tree mbh(xmin, xmax, ymin, ymax): " + rTree.mbh[0].min + " " + rTree.mbh[0].max + " " + rTree.mbh[1].min + " " + rTree.mbh[1].max);
                    break;
                }
                case 4: {
                    System.out.println("Input array position of deleted entry");
                    string = bufferedReader.readLine();
                    stringTokenizer = new StringTokenizer(string);
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    System.out.println("mbr of entry(xmin, xmax, ymin, ymax): " + dArrayArray2[n4][0][0] + " " + dArrayArray2[n4][0][1] + " " + dArrayArray2[n4][1][0] + " " + dArrayArray2[n4][1][1]);
                    rTree.removeEntry(dArrayArray2[n4], dArrayArray2[n4]);
                    break;
                }
                case 5: {
                    rTree.showRTreePlot();
                    break;
                }
                case 6: {
                    System.out.println("Input search mbr - xmin, xmax, ymin, ymax");
                    string = bufferedReader.readLine();
                    stringTokenizer = new StringTokenizer(string);
                    dArrayArray3[0][0] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray3[0][1] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray3[1][0] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray3[1][1] = Double.parseDouble(stringTokenizer.nextToken());
                    arrayList.clear();
                    RTree rTree2 = new RTree(2, 8, 2);
                    rTree2.addEntry(dArrayArray3, dArrayArray3);
                    arrayList.clear();
                    n = rTree.anyInteract(rTree2, false, false, arrayList) ? 1 : 0;
                    if (n != 0) {
                        System.out.println("returned from search xmin, xmax, ymin, ymax:" + arrayList.size());
                        break;
                    }
                    System.out.println("null search result");
                    break;
                }
                case 7: {
                    System.out.println("Input search mbr - xmin, xmax, ymin, ymax");
                    string = bufferedReader.readLine();
                    stringTokenizer = new StringTokenizer(string);
                    dArrayArray3[0][0] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray3[0][1] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray3[1][0] = Double.parseDouble(stringTokenizer.nextToken());
                    dArrayArray3[1][1] = Double.parseDouble(stringTokenizer.nextToken());
                    arrayList.clear();
                    RTree rTree3 = new RTree(2, 8, 2);
                    rTree3.addEntry(dArrayArray3, dArrayArray3);
                    arrayList.clear();
                    n = rTree.nnSearch(rTree3, false, false, arrayList) ? 1 : 0;
                    if (n != 0) {
                        System.out.println("returned from search xmin, xmax, ymin, ymax:" + arrayList.size());
                        break;
                    }
                    System.out.println("null search result");
                }
            }
        }
        System.exit(0);
    }

    public void leafDump() {
        Stack<StackEntry> stack = new Stack<StackEntry>();
        stack.ensureCapacity((this.levels - 1) * this.nodeSize);
        stack.push(new StackEntry(this.root, 0));
        while (!stack.isEmpty()) {
            StackEntry stackEntry = (StackEntry)stack.pop();
            TreeNode treeNode = stackEntry.nP;
            for (int i = 0; i < treeNode.fillCount; ++i) {
                if (stackEntry.nodeLevel == this.levels) {
                    String string = treeNode.ptrs[i].toString();
                    System.out.print(string.substring(string.indexOf("@"), string.length()) + " ");
                    System.out.print(treeNode.spans[i][0].min + " " + treeNode.spans[i][0].max + " " + treeNode.spans[i][1].min + " " + treeNode.spans[i][1].max + " ");
                }
                if (stackEntry.nodeLevel >= this.levels) continue;
                stack.push(new StackEntry((TreeNode)treeNode.ptrs[i], stackEntry.nodeLevel + 1));
            }
            System.out.println();
        }
    }

    public void showRTreePlot(String string) {
        new RTreePlot(string);
    }

    public void showRTreePlot() {
        new RTreePlot("");
    }

    public class RTreePlot
    extends Frame {
        RTreePlot(String string) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    RTreePlot.this.dispose();
                }
            });
            this.setBackground(Color.white);
            this.setSize(840, 840);
            this.setLocation(10, 30);
            this.setTitle(string);
            this.setVisible(true);
        }

        @Override
        public void paint(Graphics graphics) {
            Stack<StackEntry> stack = new Stack<StackEntry>();
            int n = 50;
            stack.ensureCapacity((RTree.this.levels - 1) * RTree.this.nodeSize);
            double[][] dArray = RTree.this.getMBH();
            double d = 740.0 / Math.max(dArray[0][1] - dArray[0][0], dArray[1][1] - dArray[1][0]);
            stack.push(new StackEntry(RTree.this.root, 0));
            while (!stack.isEmpty()) {
                Color color;
                StackEntry stackEntry = (StackEntry)stack.pop();
                int n2 = stackEntry.nodeLevel;
                TreeNode treeNode = stackEntry.nP;
                int n3 = RTree.this.levels - n2 - 1;
                switch (n3) {
                    case 0: {
                        color = Color.red;
                        break;
                    }
                    case 1: {
                        color = Color.blue;
                        break;
                    }
                    case 2: {
                        color = Color.green;
                        break;
                    }
                    case 3: {
                        color = Color.magenta;
                        break;
                    }
                    default: {
                        color = Color.black;
                    }
                }
                graphics.setColor(color);
                for (int i = 0; i < treeNode.fillCount; ++i) {
                    int n4 = (int)Math.round(d * (treeNode.spans[i][0].min - dArray[0][0])) - 2 * n3;
                    int n5 = 740 - (int)Math.round(d * (treeNode.spans[i][1].min - dArray[1][0])) + 2 * n3;
                    int n6 = (int)Math.round(d * (treeNode.spans[i][0].max - dArray[0][0])) + 2 * n3;
                    int n7 = 740 - (int)Math.round(d * (treeNode.spans[i][1].max - dArray[1][0])) - 2 * n3;
                    graphics.drawRect(n4 + n, n7 + n, n6 - n4, n5 - n7);
                    if (n2 >= RTree.this.levels - 1) continue;
                    stack.push(new StackEntry((TreeNode)treeNode.ptrs[i], n2 + 1));
                }
            }
        }
    }

    private class JoinEntryCmp
    implements Comparator {
        boolean ascOrder;

        JoinEntryCmp(boolean bl) {
            this.ascOrder = bl;
        }

        public int compare(Object object, Object object2) {
            JoinEntry joinEntry = (JoinEntry)object;
            JoinEntry joinEntry2 = (JoinEntry)object2;
            if (Math.abs(joinEntry.entryValue - joinEntry2.entryValue) < RTREE_TOL) {
                if (joinEntry.rtree1Level == joinEntry2.rtree1Level) {
                    return joinEntry.rtree2Level > joinEntry2.rtree2Level ? 1 : -1;
                }
                return joinEntry.rtree1Level > joinEntry2.rtree1Level ? 1 : -1;
            }
            if (this.ascOrder) {
                return joinEntry.entryValue > joinEntry2.entryValue ? 1 : -1;
            }
            return joinEntry.entryValue < joinEntry2.entryValue ? 1 : -1;
        }
    }

    private class JoinEntry {
        Object rtree1Obj;
        Object rtree2Obj;
        int rtree1Level;
        int rtree2Level;
        Span[] intsxnRegion;
        double entryValue;

        JoinEntry(Object object, Object object2, int n, int n2, Span[] spanArray, double d) {
            this.rtree1Obj = object;
            this.rtree2Obj = object2;
            this.rtree1Level = n;
            this.rtree2Level = n2;
            this.intsxnRegion = spanArray;
            this.entryValue = d;
        }

        JoinEntry(Object object, Object object2, int n, int n2, double d) {
            this.rtree1Obj = object;
            this.rtree2Obj = object2;
            this.rtree1Level = n;
            this.rtree2Level = n2;
            this.entryValue = d;
        }
    }

    private class MyPriorityQueue
    extends ArrayList {
        JoinEntryCmp jc;

        MyPriorityQueue(JoinEntryCmp joinEntryCmp) {
            super(100);
            this.jc = joinEntryCmp;
        }

        @Override
        public boolean add(Object object) {
            if (!super.add(object)) {
                return false;
            }
            Collections.sort(this, this.jc);
            return true;
        }

        Object poll() {
            if (this.size() > 0) {
                return this.remove(0);
            }
            return null;
        }
    }

    public class ComparatorImpl
    implements Comparator {
        double[][][] s;
        int m;

        ComparatorImpl(double[][][] dArray, int n) {
            this.s = dArray;
            this.m = n;
        }

        public int compare(Object object, Object object2) {
            double d = this.s[((Int)object).integer][this.m][0] + this.s[((Int)object).integer][this.m][1];
            double d2 = this.s[((Int)object2).integer][this.m][0] + this.s[((Int)object2).integer][this.m][1];
            if (d > d2) {
                return 1;
            }
            if (d == d2) {
                return 0;
            }
            return -1;
        }
    }

    private class StackEntry {
        TreeNode nP;
        int nodeLevel;

        StackEntry(TreeNode treeNode, int n) {
            this.nP = treeNode;
            this.nodeLevel = n;
        }
    }

    private class TreeNode
    implements Serializable {
        Object[] ptrs;
        Span[][] spans;
        int fillCount;

        TreeNode() {
            this.ptrs = new Object[RTree.this.nodeSize];
            this.spans = new Span[RTree.this.nodeSize][];
            this.fillCount = 0;
            ++RTree.this.nodeCount;
        }

        public Span[] bounds() {
            int n;
            if (this.fillCount == 0) {
                return null;
            }
            Span[] spanArray = new Span[RTree.this.nDimensions];
            for (n = 0; n < RTree.this.nDimensions; ++n) {
                spanArray[n] = new Span(this.spans[0][n]);
            }
            for (n = 1; n < this.fillCount; ++n) {
                for (int i = 0; i < RTree.this.nDimensions; ++i) {
                    if (this.spans[n][i].min < spanArray[i].min) {
                        spanArray[i].min = this.spans[n][i].min;
                    }
                    if (!(this.spans[n][i].max > spanArray[i].max)) continue;
                    spanArray[i].max = this.spans[n][i].max;
                }
            }
            return spanArray;
        }
    }

    private class Int {
        int integer;

        Int() {
        }

        Int(int n) {
            this.integer = n;
        }
    }

    private class Span
    implements Serializable {
        double min;
        double max;

        Span() {
        }

        Span(double d, double d2) {
            this.min = d;
            this.max = d2;
        }

        Span(Span span) {
            this.min = span.min;
            this.max = span.max;
        }
    }
}

