/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Las2SqlLdr {
    public static long hilbert_xy2d(long l, long l2, long l3) {
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = l2;
        long l8 = l3;
        for (long i = l >> 1; i >= 1L; i >>= 1) {
            l4 = (l7 & i) > 0L ? 1 : 0;
            l5 = (l8 & i) > 0L ? 1 : 0;
            l6 += i * i * (3L * l4 ^ l5);
            if (l5 != 0L) continue;
            if (l4 == 1L) {
                l7 = i - 1L - l7;
                l8 = i - 1L - l8;
            }
            long l9 = l7;
            l7 = l8;
            l8 = l9;
        }
        return l6;
    }

    private static void skipBytes(DataInputStream dataInputStream, long l) throws IOException {
        dataInputStream.skipBytes((int)l);
    }

    public static void readHeader(DataInputStream dataInputStream, String string) throws IOException {
        byte[] byArray = new byte[8];
        long l = Math.round(Math.pow(2.0, 31.0));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(System.out);
        Las2SqlLdr.skipBytes(dataInputStream, 24L);
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        double d = (double)n + 0.1 * (double)n2;
        block0 : switch (n * 1000 + n2) {
            case 1000: {
                Las2SqlLdr.skipBytes(dataInputStream, 68L);
                int n3 = dataInputStream.readUnsignedByte();
                int n4 = dataInputStream.readUnsignedByte();
                int n5 = n3 + n4 * 256;
                dataInputStream.readFully(byArray, 0, 4);
                long l2 = byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
                Las2SqlLdr.skipBytes(dataInputStream, 4L);
                int n6 = dataInputStream.readUnsignedByte();
                n3 = dataInputStream.readUnsignedByte();
                n4 = dataInputStream.readUnsignedByte();
                int n7 = n3 + n4 * 256;
                dataInputStream.readFully(byArray, 0, 4);
                long l3 = byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
                Las2SqlLdr.skipBytes(dataInputStream, 20L);
                dataInputStream.readFully(byArray, 0, 8);
                double d2 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                dataInputStream.readFully(byArray, 0, 8);
                double d3 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                dataInputStream.readFully(byArray, 0, 8);
                double d4 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                dataInputStream.readFully(byArray, 0, 8);
                double d5 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                dataInputStream.readFully(byArray, 0, 8);
                double d6 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                dataInputStream.readFully(byArray, 0, 8);
                double d7 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                dataInputStream.readFully(byArray, 0, 8);
                double d8 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                dataInputStream.readFully(byArray, 0, 8);
                double d9 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                dataInputStream.readFully(byArray, 0, 8);
                double d10 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                dataInputStream.readFully(byArray, 0, 8);
                double d11 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                dataInputStream.readFully(byArray, 0, 8);
                double d12 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                dataInputStream.readFully(byArray, 0, 8);
                double d13 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                Las2SqlLdr.skipBytes(dataInputStream, l2 - (long)n5);
                switch (n6) {
                    case 0: 
                    case 1: {
                        for (long i = 0L; i < l3; ++i) {
                            int n8;
                            dataInputStream.readFully(byArray, 0, 4);
                            double d14 = (double)(byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF) * d2 + d5;
                            dataInputStream.readFully(byArray, 0, 4);
                            double d15 = (double)(byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF) * d3 + d6;
                            dataInputStream.readFully(byArray, 0, 4);
                            double d16 = (double)(byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF) * d4 + d7;
                            n3 = dataInputStream.readUnsignedByte();
                            n4 = dataInputStream.readUnsignedByte();
                            int n9 = n3 + n4 * 256;
                            int n10 = n8 = dataInputStream.readByte();
                            int n11 = n10 & 1;
                            int n12 = (n10 >>= 1) & 1;
                            int n13 = (n10 >>= 1) & 7;
                            int n14 = n10 >> 3;
                            int n15 = dataInputStream.readUnsignedByte();
                            byte by = dataInputStream.readByte();
                            int n16 = dataInputStream.readUnsignedByte();
                            n3 = dataInputStream.readUnsignedByte();
                            n4 = dataInputStream.readUnsignedByte();
                            int n17 = n3 + n4 * 256;
                            if (n6 == 1) {
                                dataInputStream.skip(8L);
                            }
                            long l4 = Las2SqlLdr.hilbert_xy2d(l, Math.round(d14) + l / 2L, Math.round(d15) + l / 2L);
                            int n18 = Las2SqlLdr.getPyramidLevel(i + 1L);
                            ((OutputStream)bufferedOutputStream).write((d14 + "," + d15 + "," + d16 + "," + n9 + "," + n14 + "," + n13 + "," + n12 + "," + n11 + "," + n15 + "," + by + "," + n16 + "," + n17 + "," + l4 + "," + n18 + "," + string + "," + d + "," + n6 + "," + (i + 1L) + "\n").getBytes());
                        }
                        break block0;
                    }
                    default: {
                        throw new RuntimeException("Point format " + n6 + " not known in LAS " + n + "." + n2 + ".");
                    }
                }
            }
            case 1001: {
                throw new RuntimeException("LAS Version 1.1 not yet supported.");
            }
            case 1002: {
                throw new RuntimeException("LAS Version 1.2 not yet supported.");
            }
            case 1003: {
                throw new RuntimeException("LAS Version 1.3 not yet supported.");
            }
            case 1004: {
                throw new RuntimeException("LAS Version 1.4 not yet supported.");
            }
            default: {
                throw new RuntimeException("LAS Version " + n + "." + n2 + " not yet supported.");
            }
        }
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
    }

    public static int getPyramidLevel(long l) {
        int n = 10;
        int n2 = 1;
        while (l % (long)n <= 0L) {
            n *= 10;
            ++n2;
        }
        return n2;
    }

    public static void tfmLas(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            Las2SqlLdr.readHeader(dataInputStream, string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void main(String[] stringArray) {
        Las2SqlLdr.tfmLas(stringArray[0]);
    }
}

