/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.SqlJetAutoVacuumMode;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;

public class SqlJetOptions
implements ISqlJetOptions {
    private static final int SCHEMA_COOKIE = 1;
    private static final int FILE_FORMAT = 2;
    private static final int PAGE_CACHE_SIZE = 3;
    private static final int AUTOVACUUM = 4;
    private static final int ENCODING = 5;
    private static final int USER_COOKIE = 6;
    private static final int INCREMENTAL_VACUUM = 7;
    private final ISqlJetBtree btree;
    private final ISqlJetDbHandle dbHandle;
    private int schemaCookie;
    private int fileFormat = SQLJET_DEFAULT_FILE_FORMAT;
    private int pageCacheSize = 2000;
    private boolean autovacuum = ISqlJetBtree.SQLJET_DEFAULT_AUTOVACUUM != SqlJetAutoVacuumMode.NONE;
    private SqlJetEncoding encoding = SQLJET_DEFAULT_ENCODING;
    private int userCookie;
    private boolean incrementalVacuum = ISqlJetBtree.SQLJET_DEFAULT_AUTOVACUUM == SqlJetAutoVacuumMode.INCR;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlJetOptions(ISqlJetBtree btree, ISqlJetDbHandle dbHandle) throws SqlJetException {
        this.btree = btree;
        this.dbHandle = dbHandle;
        if (this.readSchemaCookie() == 0) {
            try {
                this.initMeta();
                return;
            }
            catch (SqlJetException e) {
                if (SqlJetErrorCode.READONLY == e.getErrorCode()) return;
                throw e;
            }
        } else {
            this.readMeta();
        }
    }

    private void readMeta() throws SqlJetException {
        this.schemaCookie = this.readSchemaCookie();
        this.autovacuum = this.readAutoVacuum();
        this.fileFormat = this.readFileFormat();
        this.incrementalVacuum = this.readIncrementalVacuum();
        this.userCookie = this.readUserCookie();
        this.pageCacheSize = this.readPageCacheSize();
        this.encoding = this.readEncoding();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ENCODING: " + (Object)((Object)this.encoding) + "\n");
        sb.append("SCHEMA VERSION: " + this.schemaCookie + "\n");
        sb.append("USER VERSION: " + this.userCookie + "\n");
        sb.append("FILE FORMAT: " + this.fileFormat + "\n");
        sb.append("AUTOVACUUM: " + this.autovacuum + "\n");
        sb.append("CACHE SIZE: " + this.pageCacheSize);
        return sb.toString();
    }

    private SqlJetEncoding readEncoding() throws SqlJetException {
        switch (this.btree.getMeta(5)) {
            case 0: {
                if (this.readSchemaCookie() != 0) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
            }
            case 1: {
                return SqlJetEncoding.UTF8;
            }
            case 2: {
                return SqlJetEncoding.UTF16LE;
            }
            case 3: {
                return SqlJetEncoding.UTF16BE;
            }
        }
        throw new SqlJetException(SqlJetErrorCode.CORRUPT);
    }

    private boolean readIncrementalVacuum() throws SqlJetException {
        return this.btree.getMeta(7) != 0;
    }

    private int readUserCookie() throws SqlJetException {
        return this.btree.getMeta(6);
    }

    private boolean readAutoVacuum() throws SqlJetException {
        return this.btree.getMeta(4) != 0;
    }

    private int readPageCacheSize() throws SqlJetException {
        int meta = this.btree.getMeta(3);
        return meta > 0 ? meta : 2000;
    }

    private int readFileFormat() throws SqlJetException {
        int fileFormat = this.btree.getMeta(2);
        this.checkFileFormat(fileFormat);
        return fileFormat;
    }

    private void checkFileFormat(int fileFormat) throws SqlJetException {
        if (fileFormat < 1 || fileFormat > 4) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private int readSchemaCookie() throws SqlJetException {
        return this.btree.getMeta(1);
    }

    public int getSchemaVersion() throws SqlJetException {
        return this.schemaCookie;
    }

    public int getFileFormat() throws SqlJetException {
        return this.fileFormat;
    }

    public int getCacheSize() throws SqlJetException {
        return this.pageCacheSize;
    }

    public boolean isAutovacuum() throws SqlJetException {
        return this.autovacuum;
    }

    public SqlJetEncoding getEncoding() throws SqlJetException {
        return this.encoding;
    }

    public boolean isLegacyFileFormat() throws SqlJetException {
        return this.fileFormat == 1;
    }

    public void setLegacyFileFormat(boolean flag) throws SqlJetException {
        this.fileFormat = flag ? 1 : 4;
    }

    public int getUserVersion() throws SqlJetException {
        return this.userCookie;
    }

    public boolean isIncrementalVacuum() throws SqlJetException {
        return this.incrementalVacuum;
    }

    public void setSchemaVersion(int version) throws SqlJetException {
        this.dbHandle.getMutex().enter();
        try {
            if (!this.btree.isInTrans()) {
                throw new SqlJetException("It can be performed only in active transaction");
            }
            this.verifySchemaVersion(true);
            this.schemaCookie = version;
            this.writeSchemaCookie(this.schemaCookie);
        }
        finally {
            this.dbHandle.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifySchemaVersion(boolean throwIfStale) throws SqlJetException {
        this.dbHandle.getMutex().enter();
        try {
            boolean stale;
            boolean bl = stale = this.schemaCookie != this.btree.getMeta(1);
            if (stale && throwIfStale) {
                throw new SqlJetException(SqlJetErrorCode.SCHEMA);
            }
            boolean bl2 = !stale;
            return bl2;
        }
        finally {
            this.dbHandle.getMutex().leave();
        }
    }

    public void changeSchemaVersion() throws SqlJetException {
        this.dbHandle.getMutex().enter();
        try {
            if (!this.btree.isInTrans()) {
                throw new SqlJetException("It can be performed only in active transaction");
            }
            this.verifySchemaVersion(true);
            ++this.schemaCookie;
            this.writeSchemaCookie(this.schemaCookie);
        }
        finally {
            this.dbHandle.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMeta() throws SqlJetException {
        boolean inTrans = this.btree.isInTrans();
        SqlJetTransactionMode transMode = this.btree.getTransMode();
        try {
            if (!inTrans || transMode != SqlJetTransactionMode.EXCLUSIVE) {
                this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            }
            try {
                this.schemaCookie = 1;
                this.writeSchemaCookie(this.schemaCookie);
                this.writeFileFormat(this.fileFormat);
                this.writePageCacheSize(this.pageCacheSize);
                this.writeEncoding(this.encoding);
                SqlJetAutoVacuumMode btreeAutoVacuum = this.btree.getAutoVacuum();
                this.autovacuum = SqlJetAutoVacuumMode.NONE != btreeAutoVacuum;
                this.incrementalVacuum = SqlJetAutoVacuumMode.INCR == btreeAutoVacuum;
                this.writeAutoVacuum(this.autovacuum);
                this.writeIncrementalVacuum(this.incrementalVacuum);
                this.btree.commit();
            }
            catch (SqlJetException e) {
                this.btree.rollback();
                throw e;
            }
        }
        finally {
            if (inTrans && transMode != null) {
                if (!this.btree.isInTrans()) {
                    this.btree.beginTrans(transMode);
                } else if (this.btree.getTransMode() != transMode) {
                    this.btree.commit();
                    this.btree.beginTrans(transMode);
                }
            }
        }
    }

    private void writeSchemaCookie(int schemaCookie) throws SqlJetException {
        this.btree.updateMeta(1, schemaCookie);
    }

    private void writeEncoding(SqlJetEncoding encoding) throws SqlJetException {
        switch (encoding) {
            case UTF8: {
                this.btree.updateMeta(5, 1);
                break;
            }
            case UTF16LE: {
                this.btree.updateMeta(5, 2);
                break;
            }
            case UTF16BE: {
                this.btree.updateMeta(5, 3);
                break;
            }
            default: {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
        }
    }

    private void writeIncrementalVacuum(boolean incrementalVacuum) throws SqlJetException {
        this.btree.updateMeta(7, incrementalVacuum ? 1 : 0);
    }

    private void writeAutoVacuum(boolean autovacuum) throws SqlJetException {
        this.btree.updateMeta(4, autovacuum ? 1 : 0);
    }

    private void writePageCacheSize(int pageCacheSize) throws SqlJetException {
        this.checkPageCacheSize();
        this.btree.updateMeta(3, pageCacheSize);
    }

    private void checkPageCacheSize() throws SqlJetException {
        if (this.pageCacheSize < 10) {
            this.pageCacheSize = 2000;
        }
    }

    private void writeFileFormat(int fileFormat) throws SqlJetException {
        this.checkFileFormat(fileFormat);
        this.btree.updateMeta(2, fileFormat);
    }

    public void setUserVersion(int userCookie) throws SqlJetException {
        this.dbHandle.getMutex().enter();
        try {
            if (!this.btree.isInTrans()) {
                throw new SqlJetException("It can be performed only in active transaction");
            }
            this.userCookie = userCookie;
            this.writeUserCookie(this.userCookie);
        }
        finally {
            this.dbHandle.getMutex().leave();
        }
    }

    private void writeUserCookie(int userCookie) throws SqlJetException {
        this.btree.updateMeta(6, userCookie);
    }

    private void checkSchema() throws SqlJetException {
        if (this.readSchemaCookie() != 1) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE);
        }
    }

    public void setFileFormat(int fileFormat) throws SqlJetException {
        this.dbHandle.getMutex().enter();
        try {
            this.checkSchema();
            if (this.btree.isInTrans()) {
                throw new SqlJetException("It can't be performed in active transaction");
            }
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.fileFormat = fileFormat;
                this.writeFileFormat(this.fileFormat);
                this.btree.commit();
            }
            catch (SqlJetException e) {
                this.btree.rollback();
                throw e;
            }
        }
        finally {
            this.dbHandle.getMutex().leave();
        }
    }

    public void setCacheSize(int pageCacheSize) throws SqlJetException {
        this.dbHandle.getMutex().enter();
        try {
            if (!this.btree.isInTrans()) {
                throw new SqlJetException("It can be performed only in active transaction");
            }
            this.pageCacheSize = pageCacheSize;
            this.writePageCacheSize(this.pageCacheSize);
        }
        finally {
            this.dbHandle.getMutex().leave();
        }
    }

    public void setAutovacuum(boolean autovacuum) throws SqlJetException {
        this.dbHandle.getMutex().enter();
        try {
            this.checkSchema();
            if (this.btree.isInTrans()) {
                throw new SqlJetException("It can't be performed in active transaction");
            }
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.autovacuum = autovacuum;
                this.writeAutoVacuum(this.autovacuum);
                this.btree.commit();
            }
            catch (SqlJetException e) {
                this.btree.rollback();
                throw e;
            }
        }
        finally {
            this.dbHandle.getMutex().leave();
        }
    }

    public void setEncoding(SqlJetEncoding encoding) throws SqlJetException {
        this.dbHandle.getMutex().enter();
        try {
            this.checkSchema();
            if (this.btree.isInTrans()) {
                throw new SqlJetException("It can't be performed in active transaction");
            }
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.encoding = encoding;
                this.writeEncoding(this.encoding);
                this.btree.commit();
            }
            catch (SqlJetException e) {
                this.btree.rollback();
                throw e;
            }
        }
        finally {
            this.dbHandle.getMutex().leave();
        }
    }

    public void setIncrementalVacuum(boolean incrementalVacuum) throws SqlJetException {
        this.dbHandle.getMutex().enter();
        try {
            this.checkSchema();
            if (this.btree.isInTrans()) {
                throw new SqlJetException("It can't be performed in active transaction");
            }
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.incrementalVacuum = incrementalVacuum;
                this.writeIncrementalVacuum(this.incrementalVacuum);
                this.btree.commit();
            }
            catch (SqlJetException e) {
                this.btree.rollback();
                throw e;
            }
        }
        finally {
            this.dbHandle.getMutex().leave();
        }
    }
}

