/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;
import oracle.security.digsig.KeyStoreWrapper;
import oracle.security.digsig.SignatureProperties;
import oracle.security.digsig.Utilities;
import oracle.security.digsig.VerifierSPI;

public class Verifier {
    public static final boolean SUCCESS = true;
    public static final boolean FAILURE = false;
    private static final int VERIFIER_STATE_START = 1;
    private static final int VERIFIER_STATE_UPDATE_DOC = 2;
    private static final int VERIFIER_STATE_UPDATE_SIG = 3;
    private static final int VERIFIER_STATE_FINISH = 4;
    private int verifierState;
    protected int verifierMode;
    protected boolean verifierStatus;
    protected X509Certificate verifierSignerX509Cert;
    protected boolean verifierAttached;
    protected Properties verifierConfig;
    protected KeyStore verifierKeyStore;
    protected Vector verifierTrustPoints;
    protected int verifierSignatureFormat;
    protected String verifierErrorMessage;
    protected StringBuffer verifierSignature;
    protected ByteArrayOutputStream verifierDocBuffer;
    protected CertificateMapper verifierCertificateMapper;
    protected VerifierSPI verifierSPIImpl;

    Verifier() {
    }

    Verifier(KeyStoreWrapper pKeyStore, CertificateMapper pCertificateMapper, Properties pConfig) throws DigitalSignatureException {
        if (pKeyStore == null) {
            throw new DigitalSignatureException("KeyStore parameter is mandatory");
        }
        this.verifierConfig = pConfig;
        this.verifierKeyStore = pKeyStore.getKeyStore();
        this.verifierCertificateMapper = pCertificateMapper;
        this.verifierSignature = new StringBuffer();
        this.verifierDocBuffer = new ByteArrayOutputStream(256);
        this.verifierErrorMessage = new String();
        try {
            this.verifierTrustPoints = new Vector();
            Enumeration<String> keyStoreTrustPointAliases = this.verifierKeyStore.aliases();
            while (keyStoreTrustPointAliases.hasMoreElements()) {
                X509Certificate jdkCert;
                String alias = keyStoreTrustPointAliases.nextElement();
                if (alias == null || !this.verifierKeyStore.isCertificateEntry(alias) || (jdkCert = (X509Certificate)this.verifierKeyStore.getCertificate(alias)) == null) continue;
                this.verifierTrustPoints.addElement(Utilities.convertJCEX509CertificateToPhaosX509(jdkCert));
            }
            if (this.verifierTrustPoints.size() == 0) {
                throw new DigitalSignatureException("No trusted certificates in key store");
            }
        }
        catch (Exception e) {
            throw new DigitalSignatureException("Internal error - " + e);
        }
    }

    public void start() {
        this.verifierMode = -1;
        this.verifierDocBuffer.reset();
        this.verifierSignature.delete(0, this.verifierSignature.length());
        this.verifierStatus = false;
        this.verifierState = 1;
    }

    public boolean isAttached() throws DigitalSignatureException {
        if (this.verifierState != 4) {
            throw new DigitalSignatureException("Verifier in invalid state");
        }
        return this.verifierAttached;
    }

    public int getSignatureFormat() throws DigitalSignatureException {
        return this.verifierSignatureFormat;
    }

    public SignatureProperties getSignatureProperties() throws DigitalSignatureException {
        if (this.verifierState != 4) {
            throw new DigitalSignatureException("Verifier in invalid state");
        }
        return null;
    }

    public void getDocument(ByteArrayOutputStream baos) throws DigitalSignatureException {
        try {
            this.verifierDocBuffer.writeTo(baos);
            baos.flush();
        }
        catch (IOException ex) {
            throw new DigitalSignatureException("Internal error.", ex);
        }
        this.verifierDocBuffer.reset();
    }

    public void updateSignature(String SignatureData) throws DigitalSignatureException {
        this.updateSignature(SignatureData, 0, SignatureData.length());
    }

    public void updateSignature(String SignatureData, int offset, int length) throws DigitalSignatureException {
        this.verifierSignature.append(SignatureData.toCharArray(), offset, length);
    }

    public void update(byte document) throws DigitalSignatureException {
        byte[] doc = new byte[]{document};
        this.update(doc, 0, 1);
    }

    public void update(byte[] document) throws DigitalSignatureException {
        this.update(document, 0, document.length);
    }

    public void update(byte[] document, int offset, int length) throws DigitalSignatureException {
        this.verifierDocBuffer.write(document, offset, length);
    }

    public int getSignatureMode() {
        return this.verifierMode;
    }

    public String getErrorMsg() throws DigitalSignatureException {
        if (this.verifierErrorMessage.trim().length() == 0) {
            throw new DigitalSignatureException("No previous error");
        }
        return this.verifierErrorMessage;
    }

    public boolean finish() throws DigitalSignatureException {
        if (this.verifierSignature.toString().trim().length() == 0) {
            throw new DigitalSignatureException("Insufficient signature data provided");
        }
        this.verifierState = 4;
        return true;
    }
}

