/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;
import oracle.security.digsig.KeyStoreWrapper;

public class Signer {
    public static final String SHA1_WITH_DSA = "sha1withdsa";
    public static final String MD5_WITH_RSA = "md5withrsa";
    public static final String SHA1_WITH_RSA = "sha1withrsa";
    protected int signerMode;
    protected int signerFormat;
    protected boolean isAttached;
    protected String signerAlias;
    protected Properties signerConfig;
    protected PrivateKey signerPrivateKey;
    protected KeyStore signerKeyStore;
    protected byte[] signerDigestBits;
    protected X509Certificate signerCertificate;
    protected MessageDigest signerMessageDigest;
    protected StringBuffer signerSignature;
    protected AlgorithmIdentifier signerAlgorithm;
    protected AlgorithmIdentifier signerDigestAlgorithm;
    protected AlgorithmIdentifier signerPKIAlgorithm;
    protected ByteArrayOutputStream signerDocument;
    protected CertificateMapper signerCertificateMapper;

    Signer(KeyStoreWrapper ks, CertificateMapper pcm, Properties config) throws DigitalSignatureException {
        if (ks == null) {
            throw new DigitalSignatureException("KeyStore parameter is mandatory");
        }
        this.isAttached = false;
        this.signerMode = 1;
        this.signerKeyStore = ks.getKeyStore();
        this.signerConfig = config;
        this.signerCertificateMapper = pcm;
        this.signerAlgorithm = AlgID.sha_1WithRSAEncryption;
        this.signerDigestAlgorithm = AlgID.sha_1;
        this.signerPKIAlgorithm = AlgID.rsaEncryption;
        try {
            Enumeration<String> e = this.signerKeyStore.aliases();
            while (e.hasMoreElements()) {
                this.signerAlias = e.nextElement();
                if (!this.signerKeyStore.isKeyEntry(this.signerAlias)) continue;
            }
            if (this.signerAlias != null) {
                this.signerPrivateKey = (PrivateKey)this.signerKeyStore.getKey(this.signerAlias, null);
                this.signerCertificate = (X509Certificate)this.signerKeyStore.getCertificate(this.signerAlias);
            }
        }
        catch (Exception e) {
            this.signerPrivateKey = null;
            this.signerCertificate = null;
            this.signerAlias = null;
        }
        if (this.signerAlias == null) {
            throw new DigitalSignatureException("No signing keys in the keystore");
        }
    }

    public void addRecipientCertificate(X509Certificate cert) throws DigitalSignatureException {
    }

    public void addRecipientCertificates(X509Certificate[] cert) throws DigitalSignatureException {
    }

    public void addRecipientID(String id) throws DigitalSignatureException {
    }

    public void addRecipientIDs(String[] ids) throws DigitalSignatureException {
    }

    public void setSignerAlias(String alias, String password) throws DigitalSignatureException {
        if (alias != null) {
            try {
                this.signerPrivateKey = (PrivateKey)this.signerKeyStore.getKey(alias, password.toCharArray());
                this.signerCertificate = (X509Certificate)this.signerKeyStore.getCertificate(alias);
                this.signerAlias = alias;
            }
            catch (Exception e) {
                this.signerPrivateKey = null;
                this.signerCertificate = null;
                this.signerAlias = null;
                throw new DigitalSignatureException("KeyStore getKey() failed");
            }
        }
    }

    public String getSignerAlias() {
        return this.signerAlias;
    }

    public void setSignerMode(int signMode) throws DigitalSignatureException {
        if (signMode != 1) {
            throw new DigitalSignatureException("Unsupported Signer Mode");
        }
        this.signerMode = signMode;
    }

    public int getSignerMode() {
        return this.signerMode;
    }

    public void setSignatureAlgorithm(String sigAlgorithm) throws DigitalSignatureException {
        if (sigAlgorithm.compareToIgnoreCase(SHA1_WITH_DSA) == 0) {
            this.signerAlgorithm = AlgID.dsaWithSHA1;
            this.signerDigestAlgorithm = AlgID.sha_1;
            this.signerPKIAlgorithm = AlgID.dsa;
        } else if (sigAlgorithm.compareToIgnoreCase(MD5_WITH_RSA) == 0) {
            this.signerAlgorithm = AlgID.md5WithRSAEncryption;
            this.signerDigestAlgorithm = AlgID.md5;
            this.signerPKIAlgorithm = AlgID.rsaEncryption;
        } else if (sigAlgorithm.compareToIgnoreCase(SHA1_WITH_RSA) == 0) {
            this.signerAlgorithm = AlgID.sha_1WithRSAEncryption;
            this.signerDigestAlgorithm = AlgID.sha_1;
            this.signerPKIAlgorithm = AlgID.rsaEncryption;
        } else {
            throw new DigitalSignatureException("Unsupported signature algorithm");
        }
    }

    public String getSignatureAlgorithm() {
        return this.signerAlgorithm.toString();
    }

    public void setEncryptionAlgorithm(String encAlgorithm) throws DigitalSignatureException {
    }

    public String getEncryptionAlgorithm() {
        return null;
    }

    public void setAttached() {
        this.isAttached = true;
    }

    public boolean isAttached() {
        return this.isAttached;
    }

    public void getDocument(ByteArrayOutputStream baos) throws DigitalSignatureException {
        try {
            this.signerDocument.writeTo(baos);
            this.signerDocument.reset();
        }
        catch (IOException ie) {
            throw new DigitalSignatureException("Internal Error");
        }
    }

    public void getSignature(StringBuffer sb) {
        sb.append(this.signerSignature.toString());
        this.signerSignature.delete(0, this.signerSignature.length());
    }

    public void start() throws DigitalSignatureException {
        if (this.isAttached) {
            if (this.signerDocument == null) {
                this.signerDocument = new ByteArrayOutputStream();
            } else {
                this.signerDocument.reset();
            }
        }
        switch (this.signerMode) {
            case 1: {
                if (this.signerSignature == null) {
                    this.signerSignature = new StringBuffer();
                } else {
                    this.signerSignature.delete(0, this.signerSignature.length());
                }
                try {
                    if (this.signerMessageDigest == null) {
                        this.signerMessageDigest = MessageDigest.getInstance(CMSUtils.getAlgoName((AlgorithmIdentifier)this.signerDigestAlgorithm, (boolean)true));
                        break;
                    }
                    this.signerMessageDigest.reset();
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new DigitalSignatureException("Invalid Signature Algorithm");
                }
            }
        }
    }

    public void update(byte plaintext) throws DigitalSignatureException {
        if (this.isAttached) {
            this.signerDocument.write(plaintext);
        }
        if (this.signerMessageDigest == null) {
            throw new DigitalSignatureException("Uninitialized Message Digest");
        }
        this.signerMessageDigest.update(plaintext);
    }

    public void update(byte[] plaintext) throws DigitalSignatureException {
        if (this.isAttached) {
            try {
                this.signerDocument.write(plaintext);
            }
            catch (IOException ie) {
                throw new DigitalSignatureException("Document update error");
            }
        }
        if (this.signerMessageDigest == null) {
            throw new DigitalSignatureException("Uninitialized Message Digest");
        }
        this.signerMessageDigest.update(plaintext);
    }

    public void update(byte[] plaintext, int offset, int length) throws DigitalSignatureException {
        if (this.isAttached) {
            this.signerDocument.write(plaintext, offset, length);
        }
        if (this.signerMessageDigest == null) {
            throw new DigitalSignatureException("Uninitialized Message Digest");
        }
        this.signerMessageDigest.update(plaintext, offset, length);
    }

    public void finish() throws DigitalSignatureException {
        if (this.isAttached) {
            try {
                this.signerDocument.flush();
            }
            catch (IOException ie) {
                throw new DigitalSignatureException("Document update error");
            }
        }
        if (this.signerMessageDigest == null) {
            throw new DigitalSignatureException("Uninitialized message digest");
        }
        this.signerDigestBits = this.signerMessageDigest.digest();
        this.signerMessageDigest.reset();
    }
}

