/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.protocol;

import oracle.security.xmlsec.saml2.core.Conditions;
import oracle.security.xmlsec.saml2.core.Subject;
import oracle.security.xmlsec.saml2.protocol.NameIDPolicy;
import oracle.security.xmlsec.saml2.protocol.RequestAbstract;
import oracle.security.xmlsec.saml2.protocol.RequestedAuthnContext;
import oracle.security.xmlsec.saml2.protocol.Scoping;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthnRequest
extends RequestAbstract {
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:2.0:protocol"};
    private static final String[] tagList = new String[]{"Issuer", "Signature", "Extensions", "Subject", "NameIDPolicy", "Conditions", "RequestedAuthnContext", "Scoping"};

    public AuthnRequest(Element element) throws DOMException {
        super(element);
    }

    public AuthnRequest(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthnRequest(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    public void setForceAuthn(boolean force) {
        this.setAttribute("ForceAuthn", String.valueOf(force));
    }

    public boolean getForceAuthn() {
        String str;
        return this.hasAttribute("ForceAuthn") && ("true".equals(str = this.getAttribute("ForceAuthn")) || "1".equals(str));
    }

    public void setIsPassive(boolean passive) {
        this.setAttribute("IsPassive", String.valueOf(passive));
    }

    public boolean getIsPassive() {
        String str;
        return this.hasAttribute("IsPassive") && ("true".equals(str = this.getAttribute("IsPassive")) || "1".equals(str));
    }

    public void setProtocolBinding(String url) {
        this.setAttribute("ProtocolBinding", url);
    }

    public String getProtocolBinding() {
        if (this.hasAttribute("ProtocolBinding")) {
            return this.getAttribute("ProtocolBinding");
        }
        return null;
    }

    public void setAssertionConsumerServiceIndex(int index) {
        if (index < 0) {
            this.setAttribute("AssertionConsumerServiceIndex", Integer.toString(0));
        } else {
            this.setAttribute("AssertionConsumerServiceIndex", Integer.toString(index));
        }
    }

    public int getAssertionConsumerServiceIndex() {
        int c = 0;
        try {
            if (this.hasAttribute("AssertionConsumerServiceIndex")) {
                c = Integer.parseInt(this.getAttribute("AssertionConsumerServiceIndex"));
            }
        }
        catch (NumberFormatException ex) {
            c = 0;
        }
        return c;
    }

    public void setAssertionConsumerServiceURL(String url) {
        this.setAttribute("AssertionConsumerServiceURL", url);
    }

    public String getAssertionConsumerServiceURL() {
        if (this.hasAttribute("AssertionConsumerServiceURL")) {
            return this.getAttribute("AssertionConsumerServiceURL");
        }
        return null;
    }

    public void setAttributeConsumingServiceIndex(int index) {
        if (index < 0) {
            this.setAttribute("AttributeConsumingServiceIndex", Integer.toString(0));
        } else {
            this.setAttribute("AttributeConsumingServiceIndex", Integer.toString(index));
        }
    }

    public int getAttributeConsumingServiceIndex() {
        int c = 0;
        try {
            if (this.hasAttribute("AttributeConsumingServiceIndex")) {
                c = Integer.parseInt(this.getAttribute("AttributeConsumingServiceIndex"));
            }
        }
        catch (NumberFormatException ex) {
            c = 0;
        }
        return c;
    }

    public void setProviderName(String name) {
        this.setAttribute("ProviderName", name);
    }

    public String getProviderName() {
        if (this.hasAttribute("ProviderName")) {
            return this.getAttribute("ProviderName");
        }
        return null;
    }

    public void setSubject(Subject subject) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"Subject");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)subject, (String[])nsList, (String[])tagList);
    }

    public void setNameIDPolicy(NameIDPolicy policy) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:protocol", (String)"NameIDPolicy");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)policy, (String[])nsList, (String[])tagList);
    }

    public void setConditions(Conditions cond) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"Conditions");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)cond, (String[])nsList, (String[])tagList);
    }

    public void setRequestedAuthnContext(RequestedAuthnContext ctx) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:protocol", (String)"RequestedAuthnContext");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)ctx, (String[])nsList, (String[])tagList);
    }

    public void setScoping(Scoping scoping) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:protocol", (String)"Scoping");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)scoping, (String[])nsList, (String[])tagList);
    }

    public Subject getSubject() {
        return (Subject)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Subject");
    }

    public NameIDPolicy getNameIDPolicy() {
        return (NameIDPolicy)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:protocol", "NameIDPolicy");
    }

    public Conditions getConditions() {
        return (Conditions)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Conditions");
    }

    public RequestedAuthnContext getRequestedAuthnContext() {
        return (RequestedAuthnContext)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:protocol", "RequestedAuthnContext");
    }

    public Scoping getScoping() {
        return (Scoping)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:protocol", "Scoping");
    }

    static {
        SAML2Initializer.initialize();
    }
}

