/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.util.List;
import java.util.StringTokenizer;
import oracle.security.xmlsec.saml2.metadata.ContactPerson;
import oracle.security.xmlsec.saml2.metadata.Descriptor;
import oracle.security.xmlsec.saml2.metadata.KeyDescriptor;
import oracle.security.xmlsec.saml2.metadata.Organization;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RoleDescriptor
extends Descriptor {
    String[] tagList = new String[]{"Signature", "Extensions", "KeyDescriptor", "Organization", "ContactPerson"};
    String[] nsList = new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata"};

    public RoleDescriptor(Element element) throws DOMException {
        super(element);
    }

    public RoleDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public RoleDescriptor(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:metadata", "RoleDescriptor");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    protected RoleDescriptor(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    public void setErrorURL(String uri) {
        this.setAttribute("errorURL", uri);
    }

    public String getErrorURL() {
        if (this.hasAttribute("errorURL")) {
            return this.getAttribute("errorURL");
        }
        return null;
    }

    public void setProtocolSupportEnumeration(String[] uri) {
        StringBuffer sb = new StringBuffer();
        int n = uri.length;
        for (int i = 0; i < n; ++i) {
            sb.append(uri[i]);
            if (i == n - 1) continue;
            sb.append(" ");
        }
        this.setAttribute("protocolSupportEnumeration", sb.toString());
    }

    public String[] getProtocolSupportEnumeration() {
        if (this.hasAttribute("protocolSupportEnumeration")) {
            StringTokenizer st = new StringTokenizer(this.getAttribute("protocolSupportEnumeration"));
            int n = st.countTokens();
            if (n == 0) {
                return null;
            }
            String[] uri = new String[n];
            int i = 0;
            while (st.hasMoreTokens()) {
                uri[i++] = st.nextToken();
            }
            return uri;
        }
        return null;
    }

    public void addKeyDescriptor(KeyDescriptor kd) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)kd, (String[])this.nsList, (String[])this.tagList);
    }

    public List getKeyDescriptors() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "KeyDescriptor");
    }

    public void setOrganization(Organization org) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)org, (String[])this.nsList, (String[])this.tagList);
    }

    public Organization getOrganization() {
        return (Organization)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "Organization");
    }

    public void addContactPerson(ContactPerson cp) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)cp, (String[])this.nsList, (String[])this.tagList);
    }

    public List getContactPersons() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "ContactPerson");
    }
}

