/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.util.List;
import oracle.security.xmlsec.saml2.metadata.AssertionIDRequestService;
import oracle.security.xmlsec.saml2.metadata.AuthzService;
import oracle.security.xmlsec.saml2.metadata.NameIDFormat;
import oracle.security.xmlsec.saml2.metadata.RoleDescriptor;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PDPDescriptor
extends RoleDescriptor {
    String[] tagList = new String[]{"Signature", "Extensions", "KeyDescriptor", "Organization", "ContactPerson", "AuthzService", "AssertionIDRequestService", "NameIDFormat"};
    String[] nsList = new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata"};

    public PDPDescriptor(Element element) throws DOMException {
        super(element);
    }

    public PDPDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public PDPDescriptor(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:metadata", "PDPDescriptor");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    public void addAuthzService(AuthzService azs) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)azs, (String[])this.nsList, (String[])this.tagList);
    }

    public List getAuthzServices() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AuthzService");
    }

    public void addAssertionIDRequestService(AssertionIDRequestService ars) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)ars, (String[])this.nsList, (String[])this.tagList);
    }

    public List getAssertionIDRequestServices() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AssertionIDRequestService");
    }

    public void addNameIDFormat(NameIDFormat nid) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)nid, (String[])this.nsList, (String[])this.tagList);
    }

    public List getNameIDFormats() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "NameIDFormat");
    }
}

