/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import java.util.List;
import oracle.security.xmlsec.saml2.core.Action;
import oracle.security.xmlsec.saml2.core.Decision;
import oracle.security.xmlsec.saml2.core.Evidence;
import oracle.security.xmlsec.saml2.core.Statement;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthzDecisionStatement
extends Statement {
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion"};
    private static final String[] tagList = new String[]{"Action", "Evidence"};

    public AuthzDecisionStatement(Element element) throws DOMException {
        super(element);
    }

    public AuthzDecisionStatement(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthzDecisionStatement(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:assertion", "AuthzDecisionStatement");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    protected AuthzDecisionStatement(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    public void setResource(String resource) {
        this.setAttribute("Resource", resource);
    }

    public String getResource() {
        if (this.hasAttribute("Resource")) {
            return this.getAttribute("Resource");
        }
        return null;
    }

    public void setDecision(Decision decision) {
        this.setAttribute("Decision", decision.getValue());
    }

    public Decision getDecision() {
        if (this.hasAttribute("Decision")) {
            return new Decision(this.getAttribute("Decision"));
        }
        return null;
    }

    public void addAction(Action action) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)action, (String[])nsList, (String[])tagList);
    }

    public List getActions() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Action");
    }

    public void setEvidence(Evidence evidence) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"Evidence");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)evidence, (String[])nsList, (String[])tagList);
    }

    public Evidence getEvidence() {
        return (Evidence)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Evidence");
    }

    static {
        SAML2Initializer.initialize();
    }
}

