/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.ac;

import java.util.List;
import oracle.security.xmlsec.saml2.ac.AsymmetricDecryption;
import oracle.security.xmlsec.saml2.ac.AsymmetricKeyAgreement;
import oracle.security.xmlsec.saml2.ac.AuthenticatorSequenceGroup;
import oracle.security.xmlsec.saml2.ac.AuthenticatorType;
import oracle.security.xmlsec.saml2.ac.DigSig;
import oracle.security.xmlsec.saml2.ac.Extension;
import oracle.security.xmlsec.saml2.ac.IPAddress;
import oracle.security.xmlsec.saml2.ac.Password;
import oracle.security.xmlsec.saml2.ac.PreviousSession;
import oracle.security.xmlsec.saml2.ac.RestrictedPassword;
import oracle.security.xmlsec.saml2.ac.ResumeSession;
import oracle.security.xmlsec.saml2.ac.SharedSecretChallengeResponse;
import oracle.security.xmlsec.saml2.ac.SharedSecretDynamicPlaintext;
import oracle.security.xmlsec.saml2.ac.SubscriberLineNumber;
import oracle.security.xmlsec.saml2.ac.UserSuffix;
import oracle.security.xmlsec.saml2.ac.ZeroKnowledge;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Authenticator
extends XMLElement {
    public Authenticator(Element element) throws DOMException {
        super(element);
    }

    public Authenticator(Element element, String systemID) throws DOMException {
        super(element, systemID);
    }

    public Authenticator(Document doc, String nsURI) throws DOMException {
        super(doc, nsURI, "Authenticator");
        String prefix = XMLElement.getDefaultNSPrefix((String)nsURI);
        if (prefix != null && prefix.length() > 0) {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsURI);
        } else {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", nsURI);
        }
    }

    protected Authenticator(Document doc, String nsURI, String localName) throws DOMException {
        super(doc, nsURI, localName);
        String prefix = XMLElement.getDefaultNSPrefix((String)nsURI);
        if (prefix != null && prefix.length() > 0) {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsURI);
        } else {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", nsURI);
        }
    }

    public void setAuthenticator(AuthenticatorType auth, AuthenticatorSequenceGroup grp) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"*", (String)"*");
        this.appendChild(auth.getNode());
        if (grp != null) {
            List l = grp.getAuthenticators();
            int len = l.size();
            for (int i = 0; i < len; ++i) {
                this.appendChild(((XMLElement)l.get(i)).getNode());
            }
        }
    }

    public AuthenticatorType getAuthenticatorChoice() {
        XMLElement elem;
        Node n = this.getFirstChild();
        if (n != null && (elem = XMLUtils.getInstance((Element)((Element)n))) instanceof AuthenticatorType) {
            return (AuthenticatorType)elem;
        }
        return null;
    }

    public AuthenticatorSequenceGroup getAuthenticatorSequenceGroup() {
        AuthenticatorSequenceGroup asg = new AuthenticatorSequenceGroup();
        NodeList nl = this.getChildNodes();
        int n = nl.getLength();
        if (n <= 1) {
            return null;
        }
        for (int i = 1; i < n; ++i) {
            XMLElement elem = XMLUtils.getInstance((Element)((Element)nl.item(i)));
            if (elem instanceof PreviousSession) {
                asg.setPreviousSession((PreviousSession)elem);
                continue;
            }
            if (elem instanceof ResumeSession) {
                asg.setResumeSession((ResumeSession)elem);
                continue;
            }
            if (elem instanceof DigSig) {
                asg.setDigSig((DigSig)elem);
                continue;
            }
            if (elem instanceof Password) {
                asg.setPassword((Password)elem);
                continue;
            }
            if (elem instanceof RestrictedPassword) {
                asg.setRestrictedPassword((RestrictedPassword)elem);
                continue;
            }
            if (elem instanceof ZeroKnowledge) {
                asg.setZeroKnowledge((ZeroKnowledge)elem);
                continue;
            }
            if (elem instanceof SharedSecretChallengeResponse) {
                asg.setSharedSecretChallengeResponse((SharedSecretChallengeResponse)elem);
                continue;
            }
            if (elem instanceof SharedSecretDynamicPlaintext) {
                asg.setSharedSecretDynamicPlaintext((SharedSecretDynamicPlaintext)elem);
                continue;
            }
            if (elem instanceof IPAddress) {
                asg.setIPAddress((IPAddress)elem);
                continue;
            }
            if (elem instanceof AsymmetricDecryption) {
                asg.setAsymmetricDecryption((AsymmetricDecryption)elem);
                continue;
            }
            if (elem instanceof AsymmetricKeyAgreement) {
                asg.setAsymmetricKeyAgreement((AsymmetricKeyAgreement)elem);
                continue;
            }
            if (elem instanceof SubscriberLineNumber) {
                asg.setSubscriberLineNumber((SubscriberLineNumber)elem);
                continue;
            }
            if (elem instanceof UserSuffix) {
                asg.setUserSuffix((UserSuffix)elem);
                continue;
            }
            if (!(elem instanceof Extension)) continue;
            asg.addExtension((Extension)elem);
        }
        return asg;
    }

    static {
        SAML2Initializer.initialize();
    }
}

