/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mdb.service;

import com.healthmarketscience.jackcess.query.Query;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessStatement;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.mdb.command.MDBMessages;
import oracle.dbtools.extension.mdb.command.MDBSymbols;
import oracle.dbtools.extension.mdb.exceptions.NoDataAvailableException;
import oracle.dbtools.extension.mdb.service.MDBService;
import oracle.dbtools.extension.mdb.utils.MDBUtils;
import oracle.dbtools.extension.mdb.utils.MdbFileUtils;
import oracle.dbtools.extension.mdb.utils.QueryUtils;
import oracle.dbtools.extension.mdb.utils.UcanAccessUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeException;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeTableDef;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class MDBProvider
implements MDBService {
    private static final String VIEWS_TABLE_NAME = "VIEWS_TABLE";
    private UcanaccessConnection ucanaccess;
    private ParsedCommand parsedCommand;
    private boolean isAppend = false;
    private boolean isReplace = false;
    private boolean isTruncate = false;
    private boolean isSkip = false;

    @Override
    public void copyTable(ScriptRunnerContext ctx, Connection conn, String mdbPath, String tableName, String prefix) throws BridgeException, SQLException {
        this.ucanaccess = UcanAccessUtils.getInstance(mdbPath, ctx);
        try (UcanaccessStatement stmt = this.ucanaccess.createStatement();){
            String tableNameWithPrefixCheck = this.addPrefixOrDefault(tableName, prefix);
            this.processMode();
            BridgeTableDef tableDef = new BridgeTableDef(tableNameWithPrefixCheck, conn, MessageFormat.format("SELECT * FROM [{0}]", tableName), (Connection)stmt.getConnection(), this.isAppend, this.isReplace, this.isTruncate, this.isSkip);
            tableDef.createTable();
            ctx.writeln(MessageFormat.format(MDBMessages.getString("MDB_SUCCESS_TABLE_COPY"), tableName));
        }
    }

    @Override
    public void copyTables(ScriptRunnerContext ctx, Connection conn, String mdbPath, String prefix) throws SQLException, NoDataAvailableException, BridgeException {
        this.ucanaccess = UcanAccessUtils.getInstance(mdbPath, ctx);
        try (UcanaccessStatement stmt = this.ucanaccess.createStatement();){
            ResultSet res = stmt.getConnection().getMetaData().getTables(null, null, "%", new String[]{"TABLE"});
            if (!res.isBeforeFirst()) {
                throw new NoDataAvailableException(MDBMessages.getString("MDB_NO_TABLES_AVAILABLE"));
            }
            while (res.next()) {
                String tableName = res.getString(3);
                String tableNameWithPrefixCheck = this.addPrefixOrDefault(tableName, prefix);
                this.processMode();
                BridgeTableDef tableDef = new BridgeTableDef(tableNameWithPrefixCheck, conn, MessageFormat.format("SELECT * FROM [{0}]", res.getString(3)), (Connection)stmt.getConnection(), this.isAppend, this.isReplace, this.isTruncate, this.isSkip);
                tableDef.createTable();
            }
            ctx.writeln(MDBMessages.getString("MDB_SUCCESS_COPY"));
        }
    }

    @Override
    public void listTables(ScriptRunnerContext ctx, Connection conn, String mdbPath) throws Exception {
        this.ucanaccess = UcanAccessUtils.getInstance(mdbPath, ctx);
        try (UcanaccessStatement stmt = this.ucanaccess.createStatement();){
            ResultSet res = stmt.getConnection().getMetaData().getTables(null, "", "%", new String[]{"TABLE"});
            if (!res.isBeforeFirst()) {
                throw new NoDataAvailableException(MDBMessages.getString("MDB_NO_TABLES_AVAILABLE"));
            }
            MDBUtils.printAsTable(ctx, res, new int[]{3});
        }
    }

    @Override
    public void copyViews(ScriptRunnerContext ctx, Connection conn, String mdbPath, String prefix) throws SQLException, IOException, NoDataAvailableException {
        this.ucanaccess = UcanAccessUtils.getInstance(mdbPath, ctx);
        this.processMode();
        try (UcanaccessStatement stmt = this.ucanaccess.createStatement();){
            List savedQueries = stmt.getConnection().getDbIO().getQueries();
            if (savedQueries.isEmpty()) {
                throw new NoDataAvailableException(MDBMessages.getString("MDB_NO_VIEWS_AVAILABLE"));
            }
            String tableName = this.addPrefixOrDefault(VIEWS_TABLE_NAME, prefix);
            if (!this.viewsTableExists(conn, tableName)) {
                this.createViewsTable(conn, tableName);
            } else {
                if (this.isSkip && this.tableContainsRows(conn, tableName)) {
                    ctx.writeln(MDBMessages.getString("MDB_COPY_SKIPPED"));
                    return;
                }
                if (this.isAppend || this.isTruncate) {
                    if (this.isTruncate) {
                        this.truncate(conn, tableName);
                    }
                } else {
                    this.drop(conn, tableName);
                    this.createViewsTable(conn, tableName);
                }
            }
            this.insertSavedQueries(ctx, conn, savedQueries, mdbPath, tableName);
        }
    }

    @Override
    public void listViews(ScriptRunnerContext ctx, Connection conn, String mdbPath) throws SQLException, IOException {
        this.ucanaccess = UcanAccessUtils.getInstance(mdbPath, ctx);
        try (UcanaccessStatement stmt = this.ucanaccess.createStatement();){
            List savedQueries = stmt.getConnection().getDbIO().getQueries();
            if (savedQueries.isEmpty()) {
                throw new NoDataAvailableException(MDBMessages.getString("MDB_NO_VIEWS_AVAILABLE"));
            }
            int headerSeparatorLength = savedQueries.stream().max(Comparator.comparing(q -> q.getName().length())).orElseThrow(() -> new NoDataAvailableException(MDBMessages.getString("MDB_NO_VIEWS_AVAILABLE"))).getName().length();
            ctx.writeln("\nVIEWS");
            ctx.writeln("-".repeat(headerSeparatorLength));
            for (Query query : savedQueries) {
                ctx.writeln(query.getName());
            }
            ctx.write("\n");
        }
    }

    @Override
    public void listAll(ScriptRunnerContext ctx, Connection conn, String mdbPath) throws Exception {
        this.ucanaccess = UcanAccessUtils.getInstance(mdbPath, ctx);
        try (UcanaccessStatement stmt = this.ucanaccess.createStatement();){
            ResultSet res = stmt.getConnection().getMetaData().getTables(null, null, "%", null);
            if (!res.isBeforeFirst()) {
                throw new NoDataAvailableException(MDBMessages.getString("MDB_NO_DATA_AVAILABLE"));
            }
            MDBUtils.printAsTable(ctx, res, new int[]{3, 4});
        }
    }

    private boolean viewsTableExists(Connection conn, String tableName) {
        String viewsTableCountSql = QueryUtils.getXMLQueries().getQuery("viewsTableExists", conn).getSql();
        DBUtil db = DBUtil.getInstance((Connection)conn);
        String count = db.executeReturnOneCol(viewsTableCountSql, Map.of("views_table_name", tableName));
        return 0 != Integer.parseInt(count);
    }

    private void insertSavedQueries(ScriptRunnerContext ctx, Connection conn, List<Query> savedQueries, String mdbPath, String tableName) throws SQLException {
        String fullMdbPath = MdbFileUtils.getAbsolutePath(mdbPath, ctx);
        for (Query query : savedQueries) {
            this.insertSavedQuery(conn, query.getName(), query.toSQLString(), fullMdbPath, tableName);
            ctx.writeln(MessageFormat.format(MDBMessages.getString("MDB_VIEW_INSERTED"), query.getName()));
        }
    }

    private void insertSavedQuery(Connection conn, String queryName, String query, String mdbFilePath, String tableName) throws SQLException {
        String insertQuery = QueryUtils.getXMLQueries().getQuery("insertSavedQuery", conn).getSql();
        if (!VIEWS_TABLE_NAME.equalsIgnoreCase(tableName)) {
            insertQuery = insertQuery.replaceAll("(?i)VIEWS_TABLE", tableName);
        }
        try (PreparedStatement stmt = conn.prepareStatement(insertQuery);){
            stmt.setString(1, queryName);
            stmt.setString(2, query);
            stmt.setString(3, mdbFilePath);
            stmt.executeUpdate();
        }
    }

    private void createViewsTable(Connection conn, String tableName) throws SQLException {
        String createQuery = QueryUtils.getXMLQueries().getQuery("createViewsTable", conn).getSql();
        if (!VIEWS_TABLE_NAME.equalsIgnoreCase(tableName)) {
            createQuery = createQuery.replaceAll("(?i)VIEWS_TABLE", tableName);
        }
        try (Statement stmt = conn.createStatement();){
            stmt.executeQuery(createQuery);
        }
    }

    private String addPrefixOrDefault(String tableName, String prefix) {
        return prefix != null ? prefix + "_" + tableName : tableName;
    }

    private void processMode() {
        String mode;
        this.resetModeValues();
        switch (mode = (String)this.parsedCommand.getOptionValue((Id)MDBSymbols.MODE)) {
            case "APPEND": {
                this.isAppend = true;
                break;
            }
            case "TRUNCATE": {
                this.isTruncate = true;
                break;
            }
            case "SKIP": {
                this.isSkip = true;
                break;
            }
            default: {
                this.isReplace = true;
            }
        }
    }

    private void resetModeValues() {
        this.isSkip = false;
        this.isTruncate = false;
        this.isReplace = false;
        this.isAppend = false;
    }

    private boolean tableContainsRows(Connection conn, String tableName) {
        DBUtil db = DBUtil.getInstance((Connection)conn);
        int count = 0;
        if (this.viewsTableExists(conn, tableName)) {
            count = Integer.parseInt(db.executeReturnOneCol("select count(*) from " + tableName));
        }
        return count != 0;
    }

    private void truncate(Connection conn, String tableName) {
        DBUtil db = DBUtil.getInstance((Connection)conn);
        db.executeReturnOneCol("TRUNCATE TABLE " + tableName);
    }

    private void drop(Connection conn, String tableName) {
        DBUtil db = DBUtil.getInstance((Connection)conn);
        db.executeReturnOneCol("DROP TABLE " + tableName);
    }

    public void setParsedCommand(ParsedCommand parsedCommand) {
        this.parsedCommand = parsedCommand;
    }
}

