/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.java;

import java.io.File;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class JFF_chmod_0_0
extends AbstractPrimitive {
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;

    public JFF_chmod_0_0() {
        super("JFF_chmod", 0, 1);
    }

    @Override
    public boolean call(IContext context, Strategy[] svars, IStrategoTerm[] tvars) {
        if (!Tools.isTermString(tvars[0])) {
            return false;
        }
        if (!Tools.isTermString(tvars[1])) {
            return false;
        }
        String fileName = Tools.asJavaString(tvars[0]);
        String modeString = Tools.asJavaString(tvars[1]);
        int mode = Integer.parseInt(modeString, 8);
        System.out.println(mode);
        if (fileName == null) {
            return true;
        }
        File f = new File(fileName);
        boolean r = true;
        boolean readable = (mode & 0x104) != 0;
        boolean readableUserOnly = (mode & 4) == 0;
        r &= f.setReadable(readable, readableUserOnly);
        boolean writable = (mode & 0x82) != 0;
        boolean writableUserOnly = (mode & 2) == 0;
        r &= f.setWritable(writable, writableUserOnly);
        boolean executable = (mode & 0x41) != 0;
        boolean executableUserOnly = (mode & 1) == 0;
        return r &= f.setWritable(executable, executableUserOnly);
    }
}

