/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.observable;

import com.google.common.collect.Queues;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Notification;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Iterator;
import java.util.Queue;
import org.metaborg.util.observable.ITestableObserver;
import org.metaborg.util.observable.TimestampedNotification;

public class TestableObserver<T>
implements ITestableObserver<T> {
    private Queue<TimestampedNotification<T>> notifications = Queues.newArrayDeque();

    public void onComplete() {
        this.notifications.add(new TimestampedNotification(Notification.createOnComplete(), System.currentTimeMillis()));
    }

    public void onError(Throwable e) {
        this.notifications.add(new TimestampedNotification(Notification.createOnError((Throwable)e), System.currentTimeMillis()));
    }

    public void onSubscribe(@NonNull Disposable d) {
    }

    public void onNext(T t) {
        this.notifications.add(new TimestampedNotification(Notification.createOnNext(t), System.currentTimeMillis()));
    }

    @Override
    public TimestampedNotification<T> peek() {
        return this.notifications.peek();
    }

    @Override
    public TimestampedNotification<T> poll() {
        return this.notifications.poll();
    }

    @Override
    public int size() {
        return this.notifications.size();
    }

    @Override
    public void clear() {
        this.notifications.clear();
    }

    @Override
    public Iterator<TimestampedNotification<T>> iterator() {
        return this.notifications.iterator();
    }
}

