/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import io.usethesource.capsule.Map;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.MultiSet;

public abstract class MultiSetMap<K, V> {
    private static final Immutable EMPTY = new Immutable(Map.Immutable.of());

    protected abstract Map<K, MultiSet.Immutable<V>> asMap();

    public Set<Map.Entry<K, MultiSet.Immutable<V>>> entrySet() {
        return this.asMap().entrySet();
    }

    public boolean isEmpty() {
        return this.asMap().isEmpty();
    }

    public int size() {
        return this.asMap().entrySet().stream().mapToInt(e -> ((MultiSet.Immutable)e.getValue()).size()).sum();
    }

    public boolean containsKey(K key) {
        return this.asMap().containsKey(key);
    }

    public boolean contains(K key, V value) {
        return this.get(key).contains(value);
    }

    public boolean containsValue(V value) {
        return this.asMap().values().stream().anyMatch(vs -> vs.contains(value));
    }

    public int count(K key, V value) {
        return this.get(key).count(value);
    }

    public MultiSet.Immutable<V> get(K key) {
        return (MultiSet.Immutable)this.asMap().getOrDefault(key, MultiSet.Immutable.of());
    }

    public Set<K> keySet() {
        return this.asMap().keySet();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultiSetMap)) {
            return false;
        }
        MultiSetMap that = (MultiSetMap)obj;
        return this.asMap().equals(that.asMap());
    }

    public int hashCode() {
        return this.asMap().hashCode();
    }

    public String toString() {
        return this.asMap().entrySet().stream().map(e -> e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    public static class Immutable<K, V>
    extends MultiSetMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map.Immutable<K, MultiSet.Immutable<V>> entries;

        private Immutable(Map.Immutable<K, MultiSet.Immutable<V>> entries) {
            this.entries = entries;
        }

        @Override
        public Map.Immutable<K, MultiSet.Immutable<V>> asMap() {
            return this.entries;
        }

        public Immutable<K, V> put(K key, V value) {
            MultiSet.Immutable values = (MultiSet.Immutable)this.entries.getOrDefault(key, MultiSet.Immutable.of());
            return new Immutable<K, V>(this.entries.__put(key, values.add(value)));
        }

        public Immutable<K, V> put(K key, V value, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative count");
            }
            if (n == 0) {
                return this;
            }
            MultiSet.Immutable values = (MultiSet.Immutable)this.entries.getOrDefault(key, MultiSet.Immutable.of());
            MultiSet.Immutable<V> newValues = values.add(value, n);
            return new Immutable<K, V>(this.entries.__put(key, newValues));
        }

        public Immutable<K, V> putAll(K key, MultiSet.Immutable<V> values) {
            MultiSet.Immutable oldValues = (MultiSet.Immutable)this.entries.get(key);
            MultiSet.Immutable<V> newValues = oldValues != null ? MultiSet.Immutable.union(oldValues, values) : values;
            return new Immutable<K, V>(this.entries.__put(key, newValues));
        }

        public Immutable<K, V> removeKey(K key) {
            return new Immutable<K, V>(this.entries.__remove(key));
        }

        public Immutable<K, V> remove(K key, V value) {
            MultiSet.Immutable values = (MultiSet.Immutable)this.entries.get(key);
            if (values == null) {
                return this;
            }
            MultiSet.Immutable<V> newValues = values.remove(value);
            Map.Immutable newEntries = newValues.isEmpty() ? this.entries.__remove(key) : this.entries.__put(key, newValues);
            return new Immutable<K, V>(newEntries);
        }

        public Immutable<K, V> removeAll(Set<K> keys) {
            Map.Transient newEntries = this.entries.asTransient();
            CapsuleUtil.filter(newEntries, k -> !keys.contains(k));
            return new Immutable<K, V>(newEntries.freeze());
        }

        public Immutable<K, V> retainAll(Set<K> keys) {
            Map.Transient newEntries = this.entries.asTransient();
            CapsuleUtil.filter(newEntries, k -> keys.contains(k));
            return new Immutable<K, V>(newEntries.freeze());
        }

        public Transient<K, V> melt() {
            return new Transient(this.entries.asTransient());
        }

        public static <K, V> Immutable<K, V> of() {
            return EMPTY;
        }
    }

    public static class Transient<K, V>
    extends MultiSetMap<K, V> {
        private final Map.Transient<K, MultiSet.Immutable<V>> entries;

        private Transient(Map.Transient<K, MultiSet.Immutable<V>> entries) {
            this.entries = entries;
        }

        @Override
        public Map.Transient<K, MultiSet.Immutable<V>> asMap() {
            return this.entries;
        }

        public int put(K key, V value) {
            return this.put(key, value, 1);
        }

        public int put(K key, V value, int n) {
            MultiSet.Immutable<Object> newValues;
            int oldCount;
            if (n < 0) {
                throw new IllegalArgumentException("Negative count");
            }
            MultiSet.Immutable oldValues = (MultiSet.Immutable)this.entries.__remove(key);
            if (oldValues != null) {
                MultiSet.Transient<V> values = oldValues.melt();
                oldCount = values.add(value, n);
                newValues = values.freeze();
            } else {
                oldCount = 0;
                newValues = MultiSet.Immutable.of(value, n);
            }
            if (!newValues.isEmpty()) {
                this.entries.__put(key, newValues);
            }
            return oldCount;
        }

        public void putAll(K key, Iterable<V> values) {
            for (V value : values) {
                this.put(key, value);
            }
        }

        public void putAll(K key, MultiSet.Immutable<V> values) {
            MultiSet.Immutable oldValues = (MultiSet.Immutable)this.entries.__remove(key);
            MultiSet.Immutable<V> newValues = oldValues != null ? MultiSet.Immutable.union(oldValues, values) : values;
            if (!newValues.isEmpty()) {
                this.entries.__put(key, newValues);
            }
        }

        public MultiSet.Immutable<V> removeKey(K key) {
            if (this.entries.containsKey(key)) {
                return (MultiSet.Immutable)this.entries.__remove(key);
            }
            return MultiSet.Immutable.of();
        }

        public int remove(K key, V value) {
            return this.remove(key, value, 1);
        }

        public int remove(K key, V value, int n) {
            MultiSet.Immutable newValues;
            int oldCount;
            if (n < 0) {
                throw new IllegalArgumentException("Negative count");
            }
            MultiSet.Immutable oldValues = (MultiSet.Immutable)this.entries.__remove(key);
            if (oldValues != null) {
                MultiSet.Transient<V> values = oldValues.melt();
                oldCount = values.remove(value, n);
                newValues = values.freeze();
            } else {
                oldCount = 0;
                newValues = MultiSet.Immutable.of();
            }
            if (!newValues.isEmpty()) {
                this.entries.__put(key, newValues);
            }
            return oldCount;
        }

        public Immutable<K, V> clear() {
            Immutable cleared = new Immutable(Map.Immutable.of().__putAll(this.entries));
            for (Object k : this.entries.keySet()) {
                this.entries.__remove(k);
            }
            return cleared;
        }

        public Immutable<K, V> freeze() {
            return this.entries.isEmpty() ? EMPTY : new Immutable(this.entries.freeze());
        }

        public static <K, V> Transient<K, V> of() {
            return new Transient<K, V>(Map.Transient.of());
        }
    }
}

