/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.build.dependency.IDependencyService;
import org.metaborg.core.context.IContext;
import org.metaborg.core.context.IContextService;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.LanguageUtils;
import org.metaborg.spoofax.core.stratego.IStrategoCommon;
import org.metaborg.spoofax.core.stratego.primitive.generic.ASpoofaxContextPrimitive;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class CallStrategyPrimitive
extends ASpoofaxContextPrimitive {
    private static final ILogger logger = LoggerUtils.logger(CallStrategyPrimitive.class);
    private final IDependencyService dependencyService;
    private final IContextService contextService;
    private final IStrategoCommon common;

    @Inject
    public CallStrategyPrimitive(IDependencyService dependencyService, IContextService contextService, IStrategoCommon common) {
        super("call_strategy", 0, 2);
        this.dependencyService = dependencyService;
        this.contextService = contextService;
        this.common = common;
    }

    @Override
    protected IStrategoTerm call(IStrategoTerm current, Strategy[] svars, IStrategoTerm[] tvars, ITermFactory factory, IContext currentContext) throws MetaborgException {
        String message;
        ILanguageImpl impl2;
        String languageName = TermUtils.toJavaString(tvars[0]);
        String strategyName = TermUtils.toJavaString(tvars[1]);
        Collection<ILanguageComponent> compileDeps = this.dependencyService.compileDeps(currentContext.project());
        Set<ILanguageImpl> impls = LanguageUtils.toImpls(compileDeps);
        ArrayList selectedImpls = Lists.newArrayList();
        for (ILanguageImpl impl2 : impls) {
            if (!impl2.belongsTo().name().equals(languageName)) continue;
            selectedImpls.add(impl2);
        }
        if (selectedImpls.isEmpty()) {
            message = logger.format("Stratego strategy call of '{}' into language '{}' failed, no language implementation found", strategyName, languageName);
            throw new MetaborgException(message);
        }
        if (selectedImpls.size() > 1) {
            message = logger.format("Stratego strategy call of '{}' into language '{}' failed, multiple language implementations found: {}", strategyName, languageName, Joiner.on((String)", ").join((Iterable)selectedImpls));
            throw new MetaborgException(message);
        }
        impl2 = (ILanguageImpl)selectedImpls.get(0);
        IContext context = this.contextService.get(currentContext.location(), currentContext.project(), impl2);
        return this.common.invoke(impl2, context, current, strategyName);
    }
}

