/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.parsetable;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

public class LabelFactory
implements Serializable {
    private static final long serialVersionUID = -8515280863057691520L;
    private int nextLabel;
    private Set<Integer> labelPool;

    public LabelFactory(int initialLabel) {
        this.nextLabel = initialLabel;
        this.labelPool = null;
    }

    public int getNextLabel() {
        int result = this.nextLabel++;
        if (this.labelPool != null) {
            if (this.labelPool.isEmpty()) {
                return result;
            }
            Iterator<Integer> i = this.labelPool.iterator();
            result = i.next();
            this.labelPool.remove(result);
            return result;
        }
        ++this.nextLabel;
        return result;
    }

    public void releaseLabel(int l) {
        if (this.labelPool == null) {
            this.labelPool = Sets.newHashSet();
        }
        this.labelPool.add(l);
    }
}

