/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build.paths;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.build.dependency.IDependencyService;
import org.metaborg.core.build.paths.ILanguagePathProvider;
import org.metaborg.core.config.IExportConfig;
import org.metaborg.core.config.IExportVisitor;
import org.metaborg.core.config.IGenerateConfig;
import org.metaborg.core.config.LangDirExport;
import org.metaborg.core.config.LangFileExport;
import org.metaborg.core.config.ResourceExport;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.project.IProject;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.resource.ResourceUtils;

public class DependencyPathProvider
implements ILanguagePathProvider {
    private final IDependencyService dependencyService;

    @Inject
    public DependencyPathProvider(IDependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    @Override
    public Iterable<FileObject> sourcePaths(IProject project, String languageName) throws MetaborgException {
        Collection<ILanguageComponent> dependencies = this.dependencyService.compileDeps(project);
        ArrayList sources = Lists.newArrayList();
        for (ILanguageComponent dependency : dependencies) {
            Collection<IGenerateConfig> generates = dependency.config().generates();
            for (IGenerateConfig generate : generates) {
                if (!languageName.equals(generate.languageName())) continue;
                this.resolve(project.location(), Iterables2.singleton(generate.directory()), sources);
            }
        }
        return sources;
    }

    @Override
    public Iterable<FileObject> includePaths(IProject project, final String languageName) throws MetaborgException {
        Collection<ILanguageComponent> dependencies = this.dependencyService.sourceDeps(project);
        final ArrayList includes = Lists.newArrayList();
        for (final ILanguageComponent dependency : dependencies) {
            Collection<IExportConfig> exports = dependency.config().exports();
            for (IExportConfig export : exports) {
                export.accept(new IExportVisitor(){

                    @Override
                    public void visit(LangDirExport export) {
                        if (languageName.equals(export.language)) {
                            DependencyPathProvider.this.resolve(dependency.location(), Iterables2.singleton(export.directory), includes);
                        }
                    }

                    @Override
                    public void visit(LangFileExport export) {
                        if (languageName.equals(export.language)) {
                            DependencyPathProvider.this.resolve(dependency.location(), Iterables2.singleton(export.file), includes);
                        }
                    }

                    @Override
                    public void visit(ResourceExport export) {
                    }
                });
            }
        }
        return includes;
    }

    private void resolve(FileObject basedir, Iterable<String> paths, Collection<FileObject> filesToAppend) {
        for (String path : paths) {
            try {
                filesToAppend.add(ResourceUtils.resolveFile(basedir, path));
            }
            catch (FileSystemException ex) {
                throw new MetaborgRuntimeException(ex);
            }
        }
    }
}

