/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core;

import com.google.common.collect.ImmutableList;
import org.metaborg.core.MetaborgException;

public class AggregateMetaborgException
extends MetaborgException {
    private static final long serialVersionUID = -6575523728704461990L;
    private final ImmutableList<MetaborgException> causes;

    public AggregateMetaborgException(Iterable<MetaborgException> causes) {
        this((ImmutableList<MetaborgException>)ImmutableList.copyOf(causes));
    }

    private AggregateMetaborgException(ImmutableList<MetaborgException> causes) {
        super("Multiple exception occurred.");
        this.causes = causes;
    }

    public Iterable<MetaborgException> getCauses() {
        return this.causes;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        for (MetaborgException cause : this.causes) {
            sb.append(" * ");
            sb.append(cause.getMessage().replace("\n", "   \n"));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void throwIfAny(Iterable<MetaborgException> exceptions) throws MetaborgException {
        ImmutableList causes = ImmutableList.copyOf(exceptions);
        switch (causes.size()) {
            case 0: {
                return;
            }
            case 1: {
                throw (MetaborgException)causes.get(0);
            }
        }
        throw new AggregateMetaborgException((ImmutableList<MetaborgException>)causes);
    }
}

