/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.primitives.Booleans;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.statix.spec.ASpec;
import mb.statix.spec.RuleSet;
import org.metaborg.util.tuple.Tuple2;

public final class Spec
extends ASpec
implements Serializable {
    private final RuleSet rules;
    private final ImmutableSet<ITerm> edgeLabels;
    private final ImmutableSet<ITerm> dataLabels;
    private final ImmutableSetMultimap<String, Tuple2<Integer, ITerm>> scopeExtensions;
    private final boolean hasPrecomputedCriticalEdges;
    private int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long ALL_LABELS_LAZY_INIT_BIT = 1L;
    private transient Set<ITerm> allLabels;
    private static final long serialVersionUID = 42L;

    private Spec(RuleSet rules, Iterable<? extends ITerm> edgeLabels, Iterable<? extends ITerm> dataLabels, Multimap<String, ? extends Tuple2<Integer, ITerm>> scopeExtensions) {
        this.rules = Objects.requireNonNull(rules, "rules");
        this.edgeLabels = ImmutableSet.copyOf(edgeLabels);
        this.dataLabels = ImmutableSet.copyOf(dataLabels);
        this.scopeExtensions = ImmutableSetMultimap.copyOf(scopeExtensions);
        this.hasPrecomputedCriticalEdges = super.hasPrecomputedCriticalEdges();
    }

    private Spec(Builder builder) {
        this.rules = builder.rules;
        this.edgeLabels = builder.edgeLabels.build();
        this.dataLabels = builder.dataLabels.build();
        this.scopeExtensions = builder.scopeExtensions.build();
        this.hasPrecomputedCriticalEdges = builder.hasPrecomputedCriticalEdgesIsSet() ? builder.hasPrecomputedCriticalEdges : super.hasPrecomputedCriticalEdges();
    }

    private Spec(RuleSet rules, ImmutableSet<ITerm> edgeLabels, ImmutableSet<ITerm> dataLabels, ImmutableSetMultimap<String, Tuple2<Integer, ITerm>> scopeExtensions, boolean hasPrecomputedCriticalEdges) {
        this.rules = rules;
        this.edgeLabels = edgeLabels;
        this.dataLabels = dataLabels;
        this.scopeExtensions = scopeExtensions;
        this.hasPrecomputedCriticalEdges = hasPrecomputedCriticalEdges;
    }

    @Override
    public RuleSet rules() {
        return this.rules;
    }

    public ImmutableSet<ITerm> edgeLabels() {
        return this.edgeLabels;
    }

    public ImmutableSet<ITerm> dataLabels() {
        return this.dataLabels;
    }

    public ImmutableSetMultimap<String, Tuple2<Integer, ITerm>> scopeExtensions() {
        return this.scopeExtensions;
    }

    @Override
    public boolean hasPrecomputedCriticalEdges() {
        return this.hasPrecomputedCriticalEdges;
    }

    public final Spec withRules(RuleSet value) {
        if (this.rules == value) {
            return this;
        }
        RuleSet newValue = Objects.requireNonNull(value, "rules");
        return new Spec(newValue, this.edgeLabels, this.dataLabels, this.scopeExtensions, this.hasPrecomputedCriticalEdges);
    }

    public final Spec withEdgeLabels(ITerm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new Spec(this.rules, (ImmutableSet<ITerm>)newValue, this.dataLabels, this.scopeExtensions, this.hasPrecomputedCriticalEdges);
    }

    public final Spec withEdgeLabels(Iterable<? extends ITerm> elements) {
        if (this.edgeLabels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new Spec(this.rules, (ImmutableSet<ITerm>)newValue, this.dataLabels, this.scopeExtensions, this.hasPrecomputedCriticalEdges);
    }

    public final Spec withDataLabels(ITerm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new Spec(this.rules, this.edgeLabels, (ImmutableSet<ITerm>)newValue, this.scopeExtensions, this.hasPrecomputedCriticalEdges);
    }

    public final Spec withDataLabels(Iterable<? extends ITerm> elements) {
        if (this.dataLabels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new Spec(this.rules, this.edgeLabels, (ImmutableSet<ITerm>)newValue, this.scopeExtensions, this.hasPrecomputedCriticalEdges);
    }

    public final Spec withScopeExtensions(Multimap<String, ? extends Tuple2<Integer, ITerm>> entries) {
        if (this.scopeExtensions == entries) {
            return this;
        }
        ImmutableSetMultimap newValue = ImmutableSetMultimap.copyOf(entries);
        return new Spec(this.rules, this.edgeLabels, this.dataLabels, (ImmutableSetMultimap<String, Tuple2<Integer, ITerm>>)newValue, this.hasPrecomputedCriticalEdges);
    }

    public final Spec withHasPrecomputedCriticalEdges(boolean value) {
        if (this.hasPrecomputedCriticalEdges == value) {
            return this;
        }
        return new Spec(this.rules, this.edgeLabels, this.dataLabels, this.scopeExtensions, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Spec && this.equalTo((Spec)another);
    }

    private boolean equalTo(Spec another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.rules.equals(another.rules) && this.edgeLabels.equals(another.edgeLabels) && this.dataLabels.equals(another.dataLabels) && this.scopeExtensions.equals(another.scopeExtensions) && this.hasPrecomputedCriticalEdges == another.hasPrecomputedCriticalEdges;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.rules.hashCode();
        h += (h << 5) + this.edgeLabels.hashCode();
        h += (h << 5) + this.dataLabels.hashCode();
        h += (h << 5) + this.scopeExtensions.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hasPrecomputedCriticalEdges);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Spec").omitNullValues().add("rules", (Object)this.rules).add("edgeLabels", this.edgeLabels).add("dataLabels", this.dataLabels).add("scopeExtensions", this.scopeExtensions).add("hasPrecomputedCriticalEdges", this.hasPrecomputedCriticalEdges).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ITerm> allLabels() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Spec spec = this;
            synchronized (spec) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.allLabels = Objects.requireNonNull(super.allLabels(), "allLabels");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.allLabels;
    }

    public static Spec of(RuleSet rules, Set<ITerm> edgeLabels, Set<ITerm> dataLabels, SetMultimap<String, Tuple2<Integer, ITerm>> scopeExtensions) {
        return Spec.of(rules, edgeLabels, dataLabels, scopeExtensions);
    }

    public static Spec of(RuleSet rules, Iterable<? extends ITerm> edgeLabels, Iterable<? extends ITerm> dataLabels, Multimap<String, ? extends Tuple2<Integer, ITerm>> scopeExtensions) {
        return new Spec(rules, edgeLabels, dataLabels, scopeExtensions);
    }

    public static Spec copyOf(ASpec instance) {
        if (instance instanceof Spec) {
            return (Spec)instance;
        }
        return Spec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Spec(Builder builder, Spec spec) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_RULES = 1L;
        private static final long OPT_BIT_HAS_PRECOMPUTED_CRITICAL_EDGES = 1L;
        private long initBits = 1L;
        private long optBits;
        private RuleSet rules;
        private ImmutableSet.Builder<ITerm> edgeLabels = ImmutableSet.builder();
        private ImmutableSet.Builder<ITerm> dataLabels = ImmutableSet.builder();
        private ImmutableSetMultimap.Builder<String, Tuple2<Integer, ITerm>> scopeExtensions = ImmutableSetMultimap.builder();
        private boolean hasPrecomputedCriticalEdges;

        private Builder() {
        }

        public final Builder from(ASpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.rules(instance.rules());
            this.addAllEdgeLabels(instance.edgeLabels());
            this.addAllDataLabels(instance.dataLabels());
            this.putAllScopeExtensions((Multimap<String, ? extends Tuple2<Integer, ITerm>>)instance.scopeExtensions());
            this.hasPrecomputedCriticalEdges(instance.hasPrecomputedCriticalEdges());
            return this;
        }

        public final Builder rules(RuleSet rules) {
            this.rules = Objects.requireNonNull(rules, "rules");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEdgeLabels(ITerm element) {
            this.edgeLabels.add((Object)element);
            return this;
        }

        public final Builder addEdgeLabels(ITerm ... elements) {
            this.edgeLabels.add((Object[])elements);
            return this;
        }

        public final Builder edgeLabels(Iterable<? extends ITerm> elements) {
            this.edgeLabels = ImmutableSet.builder();
            return this.addAllEdgeLabels(elements);
        }

        public final Builder addAllEdgeLabels(Iterable<? extends ITerm> elements) {
            this.edgeLabels.addAll(elements);
            return this;
        }

        public final Builder addDataLabels(ITerm element) {
            this.dataLabels.add((Object)element);
            return this;
        }

        public final Builder addDataLabels(ITerm ... elements) {
            this.dataLabels.add((Object[])elements);
            return this;
        }

        public final Builder dataLabels(Iterable<? extends ITerm> elements) {
            this.dataLabels = ImmutableSet.builder();
            return this.addAllDataLabels(elements);
        }

        public final Builder addAllDataLabels(Iterable<? extends ITerm> elements) {
            this.dataLabels.addAll(elements);
            return this;
        }

        public final Builder putScopeExtensions(String key, Tuple2<Integer, ITerm> ... values) {
            this.scopeExtensions.putAll((Object)key, Arrays.asList(values));
            return this;
        }

        public final Builder putAllScopeExtensions(String key, Iterable<Tuple2<Integer, ITerm>> values) {
            this.scopeExtensions.putAll((Object)key, values);
            return this;
        }

        public final Builder putScopeExtensions(String key, Tuple2<Integer, ITerm> value) {
            this.scopeExtensions.put((Object)key, value);
            return this;
        }

        public final Builder putScopeExtensions(Map.Entry<String, ? extends Tuple2<Integer, ITerm>> entry) {
            this.scopeExtensions.put(entry);
            return this;
        }

        public final Builder scopeExtensions(Multimap<String, ? extends Tuple2<Integer, ITerm>> entries) {
            this.scopeExtensions = ImmutableSetMultimap.builder();
            return this.putAllScopeExtensions(entries);
        }

        public final Builder putAllScopeExtensions(Multimap<String, ? extends Tuple2<Integer, ITerm>> entries) {
            this.scopeExtensions.putAll(entries);
            return this;
        }

        public final Builder hasPrecomputedCriticalEdges(boolean hasPrecomputedCriticalEdges) {
            this.hasPrecomputedCriticalEdges = hasPrecomputedCriticalEdges;
            this.optBits |= 1L;
            return this;
        }

        public Spec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Spec(this, null);
        }

        private boolean hasPrecomputedCriticalEdgesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("rules");
            }
            return "Cannot build Spec, some of required attributes are not set " + attributes;
        }
    }
}

