/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.ud.PersistentUniDisunifier;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.persistent.State;
import mb.statix.spec.Spec;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.functions.Function2;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ASolverResult {
    @Value.Parameter
    public abstract Spec spec();

    @Value.Parameter
    public abstract IState.Immutable state();

    @Value.Parameter
    public abstract Map<IConstraint, IMessage> messages();

    @Value.Parameter
    public abstract Map<IConstraint, Delay> delays();

    @Value.Parameter
    public abstract Map<ITermVar, ITermVar> existentials();

    @Value.Parameter
    public abstract Set<ITermVar> updatedVars();

    @Value.Parameter
    public abstract Set<CriticalEdge> removedEdges();

    @Value.Parameter
    public abstract ICompleteness.Immutable completeness();

    @Value.Default
    public int totalSolved() {
        return 0;
    }

    @Value.Default
    public int totalCriticalEdges() {
        return 0;
    }

    public boolean hasErrors() {
        return this.messages().values().stream().anyMatch(m -> m.kind().equals(MessageKind.ERROR));
    }

    public Delay delay() {
        return Delay.of(this.delays().values());
    }

    public IConstraint delayed() {
        return Constraints.conjoin(this.delays().keySet());
    }

    public static SolverResult of(Spec spec) {
        return SolverResult.of(spec, (IState.Immutable)State.of(), (Map<IConstraint, IMessage>)ImmutableMap.of(), (Map<IConstraint, Delay>)ImmutableMap.of(), (Map<ITermVar, ITermVar>)ImmutableMap.of(), (Set<ITermVar>)ImmutableSet.of(), (Set<CriticalEdge>)ImmutableSet.of(), (ICompleteness.Immutable)Completeness.Immutable.of());
    }

    public SolverResult combine(SolverResult other) {
        SolverResult.Builder combined = SolverResult.builder().from(this);
        combined.state(this.state().add(other.state()));
        combined.messages(ASolverResult.merge(this.messages(), other.messages()));
        combined.delays(ASolverResult.merge(this.delays(), other.delays(), (d1, d2) -> Delay.of(Arrays.asList(d1, d2))));
        combined.putAllExistentials((Map<? extends ITermVar, ? extends ITermVar>)other.existentials());
        combined.addAllUpdatedVars((Iterable<? extends ITermVar>)other.updatedVars());
        combined.addAllRemovedEdges((Iterable<? extends CriticalEdge>)other.removedEdges());
        combined.completeness(this.completeness().addAll(other.completeness(), PersistentUniDisunifier.Immutable.of()));
        combined.totalSolved(this.totalSolved() + other.totalSolved());
        combined.totalCriticalEdges(this.totalCriticalEdges() + other.totalCriticalEdges());
        return combined.build();
    }

    private static <K, V> Map<K, V> merge(Map<K, V> map1, Map<K, V> map2) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(map1);
        map2.forEach((k, v) -> {
            if (!map1.containsKey(k)) {
                builder.put(k, v);
            }
        });
        return builder.build();
    }

    private static <K, V> Map<K, V> merge(Map<K, V> map1, Map<K, V> map2, Function2<V, V, V> resolveConflict) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map1.forEach((k, v) -> {
            if (map2.containsKey(k)) {
                builder.put(k, resolveConflict.apply(v, map2.get(k)));
            } else {
                builder.put(k, v);
            }
        });
        map2.forEach((k, v) -> {
            if (!map1.containsKey(k)) {
                builder.put(k, v);
            }
        });
        return builder.build();
    }
}

