/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.resolution.StateMachine;
import mb.statix.constraints.AResolveQuery;
import mb.statix.constraints.CResolveQuery;
import mb.statix.constraints.IResolveQuery;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;
import mb.statix.solver.query.QueryFilter;
import mb.statix.solver.query.QueryMin;

public class CCompiledQuery
extends AResolveQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StateMachine<ITerm> stateMachine;
    private volatile int hashCode;

    public CCompiledQuery(QueryFilter filter, QueryMin min2, ITerm scopeTerm, ITerm resultTerm, StateMachine<ITerm> stateMachine) {
        this(filter, min2, scopeTerm, resultTerm, null, null, stateMachine);
    }

    public CCompiledQuery(QueryFilter filter, QueryMin min2, ITerm scopeTerm, ITerm resultTerm, @Nullable IMessage message, StateMachine<ITerm> stateMachine) {
        this(filter, min2, scopeTerm, resultTerm, null, message, stateMachine);
    }

    public CCompiledQuery(QueryFilter filter, QueryMin min2, ITerm scopeTerm, ITerm resultTerm, IConstraint cause, IMessage message, StateMachine<ITerm> stateMachine) {
        super(filter, min2, scopeTerm, resultTerm, cause, message);
        this.stateMachine = stateMachine;
    }

    public StateMachine<ITerm> stateMachine() {
        return this.stateMachine;
    }

    @Override
    public <R> R match(IResolveQuery.Cases<R> cases) {
        return cases.caseCompiledQuery(this);
    }

    @Override
    public <R, E extends Throwable> R matchInResolution(IResolveQuery.ResolutionFunction1<CResolveQuery, R> onResolveQuery, IResolveQuery.ResolutionFunction1<CCompiledQuery, R> onCompiledQuery) throws ResolutionException, InterruptedException {
        return onCompiledQuery.apply(this);
    }

    @Override
    public CCompiledQuery withCause(IConstraint cause) {
        return new CCompiledQuery(this.filter, this.min, this.scopeTerm, this.resultTerm, cause, this.message, this.stateMachine);
    }

    @Override
    public CCompiledQuery apply(ISubstitution.Immutable subst) {
        return new CCompiledQuery(this.filter.apply(subst), this.min.apply(subst), subst.apply(this.scopeTerm), subst.apply(this.resultTerm), this.cause, this.message == null ? null : this.message.apply(subst), this.stateMachine);
    }

    @Override
    public CCompiledQuery unsafeApply(ISubstitution.Immutable subst) {
        return new CCompiledQuery(this.filter.unsafeApply(subst), this.min.unsafeApply(subst), subst.apply(this.scopeTerm), subst.apply(this.resultTerm), this.cause, this.message == null ? null : this.message.apply(subst), this.stateMachine);
    }

    @Override
    public CCompiledQuery apply(IRenaming subst) {
        return new CCompiledQuery(this.filter.apply(subst), this.min.apply(subst), subst.apply(this.scopeTerm), subst.apply(this.resultTerm), this.cause, this.message == null ? null : this.message.apply(subst), this.stateMachine);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("compiled query ");
        sb.append(this.filter.toString(termToString));
        sb.append(" ");
        sb.append(this.min.toString(termToString));
        sb.append(" in ");
        sb.append(termToString.format(this.scopeTerm));
        sb.append(" |-> ");
        sb.append(termToString.format(this.resultTerm));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CCompiledQuery that = (CCompiledQuery)o;
        return Objects.equals(this.filter, that.filter) && Objects.equals(this.min, that.min) && Objects.equals(this.scopeTerm, that.scopeTerm) && Objects.equals(this.resultTerm, that.resultTerm) && Objects.equals(this.cause, that.cause) && Objects.equals(this.message, that.message) && Objects.equals(this.stateMachine, that.stateMachine);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.filter, this.min, this.scopeTerm, this.resultTerm, this.cause, this.message, this.stateMachine);
        }
        return result;
    }
}

