/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.statix.constraints.IResolveQuery;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;
import mb.statix.solver.query.QueryFilter;
import mb.statix.solver.query.QueryMin;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public abstract class AResolveQuery
implements IResolveQuery {
    protected final QueryFilter filter;
    protected final QueryMin min;
    protected final ITerm scopeTerm;
    protected final ITerm resultTerm;
    @Nullable
    protected final IConstraint cause;
    @Nullable
    protected final IMessage message;

    public AResolveQuery(QueryFilter filter, QueryMin min2, ITerm scopeTerm, ITerm resultTerm, @Nullable IConstraint cause, @Nullable IMessage message) {
        this.filter = filter;
        this.min = min2;
        this.scopeTerm = scopeTerm;
        this.resultTerm = resultTerm;
        this.cause = cause;
        this.message = message;
    }

    @Override
    public QueryFilter filter() {
        return this.filter;
    }

    @Override
    public QueryMin min() {
        return this.min;
    }

    @Override
    public ITerm scopeTerm() {
        return this.scopeTerm;
    }

    @Override
    public ITerm resultTerm() {
        return this.resultTerm;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public Optional<IMessage> message() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        Set.Transient vars = Set.Transient.of();
        vars.__insertAll(this.filter.getVars());
        vars.__insertAll(this.min.getVars());
        vars.__insertAll(this.scopeTerm.getVars());
        vars.__insertAll(this.resultTerm.getVars());
        return vars.freeze();
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.scopeTerm.getVars().forEach(onFreeVar::apply);
        this.filter.getDataWF().visitFreeVars(onFreeVar);
        this.min.getDataEquiv().visitFreeVars(onFreeVar);
        this.resultTerm.getVars().forEach(onFreeVar::apply);
        if (this.message != null) {
            this.message.visitVars(onFreeVar);
        }
    }

    public String toString() {
        return this.toString(Object::toString);
    }
}

