/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.IIncrementalTypeCheckerContext;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.impl.Result;
import mb.statix.concurrent.AbstractTypeChecker;
import mb.statix.concurrent.GroupResult;
import mb.statix.concurrent.IStatixGroup;
import mb.statix.concurrent.SolverState;
import mb.statix.concurrent.UnitResult;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.log.IDebugContext;
import mb.statix.spec.Spec;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class GroupTypeChecker
extends AbstractTypeChecker<GroupResult> {
    private static final ILogger logger = LoggerUtils.logger(GroupTypeChecker.class);
    private final IStatixGroup group;

    public GroupTypeChecker(IStatixGroup group, Spec spec, IDebugContext debug) {
        super(spec, debug);
        this.group = group;
    }

    @Override
    public IFuture<GroupResult> run(IIncrementalTypeCheckerContext<Scope, ITerm, ITerm, GroupResult, SolverState> context, List<Scope> rootScopes) {
        List<Scope> thisGroupScopes = this.group.scopeNames().stream().map(name -> this.makeSharedScope((ITypeCheckerContext<Scope, ITerm, ITerm>)context, (String)name)).collect(Collectors.toList());
        IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>>> groupResults = this.runGroups(context, this.group.groups(), thisGroupScopes);
        IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>>> unitResults = this.runUnits(context, this.group.units(), thisGroupScopes);
        thisGroupScopes.forEach(context::closeScope);
        return context.runIncremental(initialState -> {
            logger.debug("group {}: running. restarted: {}.", this.group.resource(), initialState.isPresent());
            return this.runSolver((ITypeCheckerContext<Scope, ITerm, ITerm>)context, this.group.rule(), (Optional<SolverState>)initialState, (List<Scope>)ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)rootScopes, (Iterable)thisGroupScopes)));
        }, GroupResult::solveResult, this::patch, (result, ex) -> {
            logger.debug("group {}: combining.", this.group.resource());
            return AggregateFuture.apply(groupResults, unitResults).thenApply(e -> {
                logger.debug("group {}: returning.", this.group.resource());
                return GroupResult.of(this.group.resource(), (Map)e._1(), (Map)e._2(), result, ex);
            });
        }).whenComplete((r, __) -> logger.debug("group {}: returned.", context.id()));
    }
}

