/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.regexp.impl;

import java.io.Serializable;
import java.util.Objects;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.impl.AComplement;

final class Complement<S>
extends AComplement<S>
implements Serializable {
    private final IRegExp<S> rE;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private Complement(IRegExp<S> rE) {
        this.rE = Objects.requireNonNull(rE, "rE");
    }

    private Complement(Complement<S> original, IRegExp<S> rE) {
        this.rE = rE;
    }

    @Override
    public IRegExp<S> getRE() {
        return this.rE;
    }

    public final Complement<S> withRE(IRegExp<S> value) {
        if (this.rE == value) {
            return this;
        }
        IRegExp<S> newValue = Objects.requireNonNull(value, "rE");
        return new Complement<S>(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Complement && this.equalTo((Complement)another);
    }

    private boolean equalTo(Complement<?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.rE.equals(another.rE);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.rE.hashCode();
        return h;
    }

    public static <S> Complement<S> of(IRegExp<S> rE) {
        return new Complement<S>(rE);
    }

    public static <S> Complement<S> copyOf(AComplement<S> instance) {
        if (instance instanceof Complement) {
            return (Complement)instance;
        }
        return Complement.of(instance.getRE());
    }
}

