/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms.path;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.path.IDeclPath;
import mb.scopegraph.pepm16.path.IResolutionPath;
import mb.scopegraph.pepm16.path.IScopePath;
import mb.scopegraph.pepm16.path.IStep;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.Scope;
import mb.scopegraph.pepm16.terms.path.ComposedScopePath;
import mb.scopegraph.pepm16.terms.path.DeclPath;
import mb.scopegraph.pepm16.terms.path.EStep;
import mb.scopegraph.pepm16.terms.path.EmptyScopePath;
import mb.scopegraph.pepm16.terms.path.NStep;
import mb.scopegraph.pepm16.terms.path.ResolutionPath;

public final class Paths {
    public static final String PATH_SEPERATOR = " ";

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> IStep<S, L, O> direct(S source, L label, S target) {
        return EStep.of(source, label, target);
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> IStep<S, L, O> named(S source, L label, IResolutionPath<S, L, O> importPath, S target) {
        return NStep.of(source, label, importPath, target);
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> IScopePath<S, L, O> empty(S scope) {
        return EmptyScopePath.of(scope);
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> IDeclPath<S, L, O> decl(IScopePath<S, L, O> path, O decl) {
        return DeclPath.of(path, decl);
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> Optional<IScopePath<S, L, O>> append(IScopePath<S, L, O> left, IScopePath<S, L, O> right) {
        if (left instanceof EmptyScopePath) {
            EmptyScopePath empty = (EmptyScopePath)left;
            return empty.getScope().equals(right.getSource()) ? Optional.of(right) : Optional.empty();
        }
        if (right instanceof EmptyScopePath) {
            EmptyScopePath empty = (EmptyScopePath)right;
            return left.getTarget().equals(empty.getScope()) ? Optional.of(left) : Optional.empty();
        }
        if (left instanceof ComposedScopePath) {
            ComposedScopePath inner = (ComposedScopePath)left;
            return Paths.append(inner.getRight(), right).flatMap(r -> Paths.append(inner.getLeft(), r));
        }
        return Optional.ofNullable(ComposedScopePath.of(left, right));
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> Optional<IDeclPath<S, L, O>> append(IScopePath<S, L, O> left, IDeclPath<S, L, O> right) {
        return Paths.append(left, right.getPath()).map(p -> DeclPath.of(p, right.getDeclaration()));
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> Optional<IResolutionPath<S, L, O>> resolve(O reference, IScopePath<S, L, O> path, O declaration) {
        return Optional.ofNullable(ResolutionPath.of(reference, path, declaration));
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> Optional<IResolutionPath<S, L, O>> resolve(O reference, IDeclPath<S, L, O> path) {
        return Optional.ofNullable(ResolutionPath.of(reference, path.getPath(), path.getDeclaration()));
    }

    public static IListTerm toTerm(IResolutionPath<Scope, Label, Occurrence> path) {
        IApplTerm dstep = TermBuild.B.newAppl("D", (ITerm)path.getPath().getTarget(), (ITerm)path.getDeclaration());
        return TermBuild.B.newListTail(Paths.toTerms(path.getPath()), TermBuild.B.newList(dstep));
    }

    public static IListTerm toTerm(IScopePath<Scope, Label, Occurrence> path) {
        return TermBuild.B.newList(Paths.toTerms(path));
    }

    private static List<ITerm> toTerms(IScopePath<Scope, Label, Occurrence> path) {
        ArrayList steps = Lists.newArrayList();
        for (IStep<Scope, Label, Occurrence> iStep : path) {
            steps.add((ITerm)iStep.match(IStep.ICases.of((source, label, target) -> TermBuild.B.newAppl("E", (ITerm)source, (ITerm)label), (source, label, importPath, target) -> TermBuild.B.newAppl("N", (ITerm)source, (ITerm)label, (ITerm)importPath.getReference(), Paths.toTerm(importPath)))));
        }
        return steps;
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> List<O> declPathsToDecls(Iterable<IDeclPath<S, L, O>> paths) {
        ArrayList<O> decls = new ArrayList<O>();
        for (IDeclPath<S, L, O> path : paths) {
            decls.add(path.getDeclaration());
        }
        return decls;
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> List<O> resolutionPathsToDecls(Iterable<IResolutionPath<S, L, O>> paths) {
        ArrayList decls = new ArrayList();
        for (IDeclPath iDeclPath : paths) {
            decls.add(iDeclPath.getDeclaration());
        }
        return decls;
    }
}

