/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.bottomup;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.bottomup.BUPathKey;
import mb.scopegraph.pepm16.path.IDeclPath;
import mb.scopegraph.pepm16.terms.SpacedName;
import org.metaborg.util.functions.Predicate2;

abstract class BUPathSet<S extends IScope, L extends ILabel, O extends IOccurrence, P extends IDeclPath<S, L, O>> {
    BUPathSet() {
    }

    protected abstract SetMultimap<SpacedName, BUPathKey<L>> _keys();

    protected abstract SetMultimap<BUPathKey<L>, P> _paths();

    public boolean isEmpty() {
        return this._paths().isEmpty();
    }

    public Set<SpacedName> names() {
        return this._keys().keySet();
    }

    public Set<BUPathKey<L>> keys(SpacedName name) {
        return this._keys().get((Object)name);
    }

    public Collection<P> paths() {
        return this._paths().values();
    }

    public Collection<P> paths(SpacedName name) {
        Set.Transient paths = Set.Transient.of();
        for (BUPathKey key : this._keys().get((Object)name)) {
            paths.__insertAll((Set)this._paths().get((Object)key));
        }
        return paths.freeze();
    }

    public Collection<P> paths(BUPathKey<L> key) {
        return this._paths().get(key);
    }

    static class Immutable<S extends IScope, L extends ILabel, O extends IOccurrence, P extends IDeclPath<S, L, O>>
    extends BUPathSet<S, L, O, P>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final SetMultimap.Immutable<SpacedName, BUPathKey<L>> keys;
        private final SetMultimap.Immutable<BUPathKey<L>, P> paths;

        private Immutable(SetMultimap.Immutable<SpacedName, BUPathKey<L>> keys, SetMultimap.Immutable<BUPathKey<L>, P> paths) {
            this.keys = keys;
            this.paths = paths;
        }

        @Override
        protected SetMultimap<SpacedName, BUPathKey<L>> _keys() {
            return this.keys;
        }

        @Override
        protected SetMultimap<BUPathKey<L>, P> _paths() {
            return this.paths;
        }

        public Immutable<S, L, O, P> filter(Predicate2<BUPathKey<L>, P> filter) {
            Transient filteredPaths = Transient.of();
            for (Map.Entry entry : this.paths.entrySet()) {
                if (!filter.test((BUPathKey)entry.getKey(), (IDeclPath)entry.getValue())) continue;
                filteredPaths.add((BUPathKey)entry.getKey(), (IDeclPath)entry.getValue());
            }
            return filteredPaths.freeze();
        }

        public Transient<S, L, O, P> melt() {
            return new Transient(this.keys.asTransient(), this.paths.asTransient());
        }

        public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IDeclPath<S, L, O>> Immutable<S, L, O, P> of() {
            return new Immutable<S, L, O, P>(SetMultimap.Immutable.of(), SetMultimap.Immutable.of());
        }
    }

    static class Transient<S extends IScope, L extends ILabel, O extends IOccurrence, P extends IDeclPath<S, L, O>>
    extends BUPathSet<S, L, O, P> {
        private final SetMultimap.Transient<SpacedName, BUPathKey<L>> keys;
        private final SetMultimap.Transient<BUPathKey<L>, P> paths;

        private Transient(SetMultimap.Transient<SpacedName, BUPathKey<L>> keys, SetMultimap.Transient<BUPathKey<L>, P> paths) {
            this.keys = keys;
            this.paths = paths;
        }

        @Override
        protected SetMultimap<SpacedName, BUPathKey<L>> _keys() {
            return this.keys;
        }

        @Override
        protected SetMultimap<BUPathKey<L>, P> _paths() {
            return this.paths;
        }

        public Collection<P> add(BUPathKey<L> key, Collection<P> paths) {
            Set.Transient added = Set.Transient.of();
            this.keys.__insert((Object)key.name(), key);
            for (IDeclPath path : paths) {
                if (!this.paths.__insert(key, (Object)path)) continue;
                added.__insert((Object)path);
            }
            return added.freeze();
        }

        public boolean add(BUPathKey<L> key, P path) {
            this.keys.__insert((Object)key.name(), key);
            return this.paths.__insert(key, path);
        }

        public Collection<P> remove(BUPathKey<L> key) {
            Set.Immutable removed = this.paths.get(key);
            this.paths.__remove(key);
            this.keys.__remove((Object)key.name(), key);
            return removed;
        }

        public Collection<P> remove(BUPathKey<L> key, Collection<P> paths) {
            Set.Transient removed = Set.Transient.of();
            for (IDeclPath path : paths) {
                if (!this.paths.__remove(key, (Object)path)) continue;
                removed.__insert((Object)path);
            }
            if (!this.paths.containsKey(key)) {
                this.keys.__remove((Object)key.name(), key);
            }
            return removed.freeze();
        }

        public Immutable<S, L, O, P> freeze() {
            return new Immutable(this.keys.freeze(), this.paths.freeze());
        }

        public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IDeclPath<S, L, O>> Transient<S, L, O, P> of() {
            return new Transient<S, L, O, P>(SetMultimap.Transient.of(), SetMultimap.Transient.of());
        }
    }
}

