/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path.string;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.regex.Pattern;
import mb.resource.hierarchical.match.path.string.PathStringMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RegexPathStringMatcher
implements PathStringMatcher {
    private final String pattern;
    private transient Pattern compiledPattern;

    public RegexPathStringMatcher(String pattern) {
        this.pattern = pattern;
        this.compiledPattern = Pattern.compile(pattern);
    }

    @Override
    public boolean matches(String pathString) {
        return this.compiledPattern.matcher(pathString).matches();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexPathStringMatcher that = (RegexPathStringMatcher)o;
        return this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public String toString() {
        return "RegexPathStringMatcher(" + this.pattern + ")";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.compiledPattern = Pattern.compile(this.pattern);
    }
}

