/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path.string;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import mb.resource.hierarchical.match.path.string.PathStringMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExtensionsPathStringMatcher
implements PathStringMatcher {
    private final List<String> extensions;
    private transient LinkedHashSet<String> extensionsHashSet;

    public ExtensionsPathStringMatcher(LinkedHashSet<String> extensions) {
        this.extensions = new ArrayList<String>(extensions);
        this.extensionsHashSet = extensions;
    }

    public ExtensionsPathStringMatcher(ArrayList<String> extensions) {
        this.extensions = extensions;
        this.extensionsHashSet = new LinkedHashSet<String>(extensions);
    }

    public ExtensionsPathStringMatcher(Collection<String> extensions) {
        this.extensions = new ArrayList<String>(extensions);
        this.extensionsHashSet = new LinkedHashSet<String>(extensions);
    }

    public ExtensionsPathStringMatcher(String ... extensions) {
        this.extensions = Arrays.asList(extensions);
        this.extensionsHashSet = new LinkedHashSet<String>(this.extensions);
    }

    @Override
    public boolean matches(String pathString) {
        int dotIndex = pathString.lastIndexOf(46);
        if (dotIndex == -1) {
            return false;
        }
        String extension = pathString.substring(dotIndex + 1);
        return this.extensionsHashSet.contains(extension);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionsPathStringMatcher that = (ExtensionsPathStringMatcher)o;
        return this.extensions.equals(that.extensions);
    }

    public int hashCode() {
        return this.extensions.hashCode();
    }

    public String toString() {
        return "ExtensionsPathStringMatcher(" + this.extensions + ")";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.extensionsHashSet = new LinkedHashSet<String>(this.extensions);
    }
}

