/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.diff;

import java.util.Optional;
import java.util.Set;
import mb.p_raffrayi.impl.diff.IDifferContext;
import mb.p_raffrayi.impl.diff.IDifferDataOps;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.ScopeGraphUtil;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;

public class StaticDifferContext<S, L, D>
implements IDifferContext<S, L, D> {
    private final IScopeGraph.Immutable<S, L, D> scopeGraph;
    private final Set<S> scopes;
    private final IDifferDataOps<D> dataOps;

    public StaticDifferContext(IScopeGraph.Immutable<S, L, D> scopeGraph, Set<S> scopes, IDifferDataOps<D> dataOps) {
        this.scopeGraph = scopeGraph;
        this.scopes = scopes;
        this.dataOps = dataOps;
    }

    @Override
    public IFuture<Iterable<S>> getEdges(S scope, L label) {
        return CompletableFuture.completedFuture(this.scopeGraph.getEdges(scope, label));
    }

    @Override
    public IFuture<Optional<D>> datum(S scope) {
        return CompletableFuture.completedFuture(this.rawDatum(scope));
    }

    @Override
    public Optional<D> rawDatum(S scope) {
        return this.scopeGraph.getData(scope).map(this.dataOps::getExternalRepresentation);
    }

    @Override
    public boolean available(S scope) {
        return this.scopes.contains(scope);
    }

    public String toString() {
        return "StaticDifferContext:\n" + ScopeGraphUtil.toString(this.scopeGraph, this.dataOps::getExternalRepresentation);
    }
}

