/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.diff;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import mb.p_raffrayi.impl.diff.IDifferContext;
import mb.p_raffrayi.impl.diff.IDifferOps;
import mb.p_raffrayi.impl.diff.IScopeGraphDiffer;
import mb.p_raffrayi.impl.diff.ScopeDiff;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.diff.BiMap;
import mb.scopegraph.oopsla20.diff.Edge;
import mb.scopegraph.oopsla20.diff.ScopeGraphDiff;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.patching.IPatchCollection;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class AddingDiffer<S, L, D>
implements IScopeGraphDiffer<S, L, D> {
    private static ILogger logger = LoggerUtils.logger(AddingDiffer.class);
    private final AtomicInteger pendingResults = new AtomicInteger(0);
    private final IDifferContext<S, L, D> context;
    private final IDifferOps<S, L, D> differOps;
    private final Set.Immutable<L> edgeLabels;
    private final Map.Transient<S, D> addedScopes = CapsuleUtil.transientMap();
    private final Set.Transient<Edge<S, L>> addedEdges = CapsuleUtil.transientSet();
    private final Set.Transient<S> seenScopes = CapsuleUtil.transientSet();
    private final ICompletableFuture<ScopeGraphDiff<S, L, D>> diffResult = new CompletableFuture<ScopeGraphDiff<S, L, D>>();
    private final Queue<S> worklist = Lists.newLinkedList();
    private final AtomicBoolean typeCheckerFinished = new AtomicBoolean();
    private final AtomicInteger nesting = new AtomicInteger(0);

    public AddingDiffer(IDifferContext<S, L, D> context, IDifferOps<S, L, D> differOps, Set.Immutable<L> edgeLabels) {
        this.context = context;
        this.differOps = differOps;
        this.edgeLabels = edgeLabels;
    }

    @Override
    public IFuture<ScopeGraphDiff<S, L, D>> diff(List<S> currentRootScopes, List<S> previousRootScopes) {
        currentRootScopes.forEach(this::addScope);
        this.fixedpoint();
        this.tryFinalize();
        return this.diffResult;
    }

    @Override
    public IFuture<ScopeGraphDiff<S, L, D>> diff(IScopeGraph.Immutable<S, L, D> initiallyMatchedGraph, Collection<S> scopes, Collection<S> sharedScopes, IPatchCollection.Immutable<S> patches, Collection<S> openScopes, Multimap<S, EdgeOrData<L>> openEdges) {
        throw new IllegalStateException("Adding differ cannot be used with initial scopegraph.");
    }

    private void fixedpoint() {
        try {
            this.nesting.incrementAndGet();
            while (!this.worklist.isEmpty()) {
                this.addScope(this.worklist.poll());
            }
        }
        finally {
            this.nesting.decrementAndGet();
        }
    }

    private void addScope(S scope) {
        if (!this.seenScopes.contains(scope)) {
            this.seenScopes.__insert(scope);
            if (this.differOps.ownScope(scope)) {
                IFuture<Optional<D>> datumFuture = this.context.datum(scope);
                K<Optional> processDatum = d -> {
                    this.addedScopes.__put(scope, d.orElse(this.differOps.embed(scope)));
                    d.ifPresent(datum -> this.differOps.getScopes(datum).forEach(this::addScope));
                };
                logger.trace("Schedule datum {}: {}", scope, datumFuture);
                this.future(datumFuture, processDatum);
            }
            if (this.differOps.ownOrSharedScope(scope)) {
                for (Object lbl : this.edgeLabels) {
                    IFuture<Iterable<S>> edgesFuture = this.context.getEdges(scope, lbl);
                    K<Iterable> processEdges = targets -> targets.forEach(target -> {
                        this.addedEdges.__insert(new Edge<Object, Object>(scope, lbl, target));
                        this.worklist.add(target);
                    });
                    this.future(edgesFuture, processEdges);
                }
            }
        }
    }

    private <R> void future(IFuture<R> f, K<R> k) {
        this.pendingResults.incrementAndGet();
        f.whenComplete((res, ex) -> {
            logger.debug("Complete {}.", f);
            this.pendingResults.decrementAndGet();
            if (ex != null) {
                this.diffResult.completeExceptionally((Throwable)ex);
            } else {
                this.diffK(k, res);
            }
            this.tryFinalize();
        });
    }

    private <R> void diffK(K<R> k, R r) {
        try {
            k.k(r);
            this.fixedpoint();
        }
        catch (Throwable ex) {
            this.diffResult.completeExceptionally(ex);
        }
    }

    private void tryFinalize() {
        logger.trace("Try finalize differ. Pending: {}, nesting: {}, TC finished: {}", this.pendingResults.get(), this.nesting.get(), this.typeCheckerFinished.get());
        if (this.pendingResults.get() == 0 && this.nesting.get() == 0 && this.typeCheckerFinished.get()) {
            logger.debug("Finalizing differ.");
            this.diffResult.complete(new ScopeGraphDiff(BiMap.Immutable.of(), BiMap.Immutable.of(), this.addedScopes.freeze(), this.addedEdges.freeze(), CapsuleUtil.immutableMap(), CapsuleUtil.immutableSet()));
        }
    }

    @Override
    public IFuture<Optional<S>> match(S previousScope) {
        throw new UnsupportedOperationException("There can be no previous scopes for an added unit.");
    }

    @Override
    public boolean matchScopes(BiMap.Immutable<S> scopes) {
        throw new UnsupportedOperationException("There can be no previous scopes for an added unit.");
    }

    @Override
    public void typeCheckerFinished() {
        this.typeCheckerFinished.set(true);
        this.tryFinalize();
    }

    @Override
    public IFuture<ScopeDiff<S, L, D>> scopeDiff(S previousScope, L label) {
        throw new UnsupportedOperationException("There can be no previous scopes for an added unit.");
    }

    private static interface K<R> {
        public void k(R var1);
    }
}

