/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AbstractTerm;
import mb.nabl2.terms.stratego.ATermIndex;
import mb.nabl2.terms.stratego.ITermIndex;

public final class TermIndex
extends ATermIndex
implements Serializable {
    private final IAttachments attachments;
    private final String resource;
    private final int id;
    private volatile transient long lazyInitBitmap;
    private static final long ARGS_LAZY_INIT_BIT = 1L;
    private transient List<ITerm> args;
    private static final long serialVersionUID = 42L;

    private TermIndex(String resource, int id) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.id = id;
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private TermIndex(Builder builder) {
        this.resource = builder.resource;
        this.id = builder.id;
        this.attachments = builder.attachments != null ? builder.attachments : Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private TermIndex(IAttachments attachments, String resource, int id) {
        this.attachments = attachments;
        this.resource = resource;
        this.id = id;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public final TermIndex withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new TermIndex(newValue, this.resource, this.id);
    }

    public final TermIndex withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new TermIndex(this.attachments, newValue, this.id);
    }

    public final TermIndex withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new TermIndex(this.attachments, this.resource, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITerm> getArgs() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            TermIndex termIndex = this;
            synchronized (termIndex) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.args = Objects.requireNonNull(super.getArgs(), "args");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.args;
    }

    public static TermIndex of(String resource, int id) {
        return new TermIndex(resource, id);
    }

    public static TermIndex copyOf(ATermIndex instance) {
        if (instance instanceof TermIndex) {
            return (TermIndex)instance;
        }
        return TermIndex.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ TermIndex(Builder builder, TermIndex termIndex) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private static final long INIT_BIT_ID = 2L;
        private long initBits = 3L;
        private IAttachments attachments;
        private String resource;
        private int id;

        private Builder() {
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ATermIndex instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ITermIndex instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof ATermIndex) {
                instance = (ATermIndex)object;
                if ((bits & 2L) == 0L) {
                    this.resource(((ATermIndex)instance).getResource());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(((ATermIndex)instance).getId());
                    bits |= 4L;
                }
            }
            if (object instanceof ITermIndex) {
                instance = (ITermIndex)object;
                if ((bits & 2L) == 0L) {
                    this.resource(instance.getResource());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.getId());
                    bits |= 4L;
                }
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 1L;
                }
            }
        }

        public final Builder attachments(IAttachments attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public TermIndex build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TermIndex(this, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build TermIndex, some of required attributes are not set " + attributes;
        }
    }
}

