/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import java.util.ArrayList;
import java.util.List;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.Attachments;
import mb.nabl2.terms.build.ITermBuild;
import mb.nabl2.terms.stratego.StrategoAnnotations;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.io.TermFactoryVisitor;
import org.spoofax.terms.io.TermVisitor;

public abstract class TermBuildVisitor
implements TermVisitor {
    private final ITermBuild build;
    private final ITermFactory factory;
    private Integer i;
    private Double d;
    private String s;
    private String c;
    List<ITerm> subTerms = new ArrayList<ITerm>();
    List<IStrategoTerm> annos = new ArrayList<IStrategoTerm>();

    public TermBuildVisitor(ITermBuild build, ITermFactory factory) {
        this.build = build;
        this.factory = factory;
    }

    public abstract void setTerm(ITerm var1);

    @Override
    public void visitInt(int value) {
        this.visit();
        this.i = value;
    }

    @Override
    public void endInt() {
        this.setTerm(this.withAnnos(this.build.newInt(this.i)));
    }

    @Override
    public void visitReal(double value) {
        this.visit();
        this.d = value;
    }

    @Override
    public void endReal() {
        throw new IllegalArgumentException("Reals are not supported.");
    }

    @Override
    public void visitString(String value) {
        this.visit();
        this.s = value;
    }

    @Override
    public void endString() {
        this.setTerm(this.withAnnos(this.build.newString(this.s)));
    }

    @Override
    public void visitAppl(String name) {
        this.visit();
        this.c = name;
    }

    @Override
    public void endAppl() {
        this.setTerm(this.withAnnos(this.build.newAppl(this.c, this.subTerms)));
    }

    @Override
    public void visitTuple() {
        this.visit();
    }

    @Override
    public void endTuple() {
        this.setTerm(this.withAnnos(this.build.newTuple(this.subTerms)));
    }

    @Override
    public void visitList() {
        this.visit();
    }

    @Override
    public void endList() {
        this.setTerm(this.withAnnos(this.build.newList(this.subTerms)));
    }

    @Override
    public TermVisitor visitPlaceholder() {
        throw new IllegalArgumentException("Placeholders are not supported.");
    }

    @Override
    public TermVisitor visitSubTerm() {
        final TermBuildVisitor outer = this;
        return new TermBuildVisitor(this.build, this.factory){

            @Override
            public void setTerm(ITerm subTerm) {
                outer.subTerms.add(subTerm);
            }
        };
    }

    @Override
    public TermVisitor visitAnnotation() {
        final TermBuildVisitor outer = this;
        return new TermFactoryVisitor(this.factory){

            @Override
            public void setTerm(IStrategoTerm anno) {
                outer.annos.add(anno);
            }
        };
    }

    private ITerm withAnnos(ITerm term) {
        if (this.annos.isEmpty()) {
            return term;
        }
        return term.withAttachments(Attachments.of(StrategoAnnotations.class, StrategoAnnotations.of(this.annos)));
    }

    private void visit() {
        this.i = null;
        this.d = null;
        this.s = null;
        this.c = null;
        this.subTerms.clear();
        this.annos.clear();
    }
}

