/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.primitives;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mb.nabl2.solver.ISolution;
import mb.nabl2.spoofax.primitives.AnalysisPrimitive;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.scopegraph.pepm16.CriticalEdgeException;
import mb.scopegraph.pepm16.StuckException;
import mb.scopegraph.pepm16.path.IResolutionPath;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.Scope;
import mb.scopegraph.pepm16.terms.path.Paths;
import org.metaborg.util.task.NullProgress;
import org.metaborg.util.task.ThreadCancel;
import org.spoofax.interpreter.core.InterpreterException;

public class SG_get_ref_resolution
extends AnalysisPrimitive {
    public SG_get_ref_resolution() {
        super(SG_get_ref_resolution.class.getSimpleName(), 0);
    }

    @Override
    public Optional<? extends ITerm> call(ISolution solution, ITerm term, List<ITerm> terms) throws InterpreterException {
        Optional<Occurrence> maybeRef = Occurrence.matcher().match(term, solution.unifier());
        return maybeRef.flatMap(ref -> {
            try {
                Collection paths = solution.nameResolution().resolve((Occurrence)ref, new ThreadCancel(), new NullProgress());
                ArrayList pathTerms = Lists.newArrayListWithExpectedSize((int)paths.size());
                for (IResolutionPath<Scope, Label, Occurrence> iResolutionPath : paths) {
                    pathTerms.add(TermBuild.B.newTuple((ITerm)iResolutionPath.getDeclaration(), Paths.toTerm(iResolutionPath)));
                }
                IListTerm iListTerm = TermBuild.B.newList(pathTerms);
                return Optional.of(iListTerm);
            }
            catch (InterruptedException | CriticalEdgeException | StuckException e) {
                return Optional.empty();
            }
        });
    }
}

