/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.components;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import mb.nabl2.constraints.Constraints;
import mb.nabl2.constraints.base.CConj;
import mb.nabl2.constraints.base.CExists;
import mb.nabl2.constraints.base.CNew;
import mb.nabl2.constraints.base.IBaseConstraint;
import mb.nabl2.constraints.equality.CEqual;
import mb.nabl2.constraints.messages.MessageContent;
import mb.nabl2.solver.ASolver;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.PersistentSubstitution;
import mb.scopegraph.pepm16.terms.Scope;

public class BaseComponent
extends ASolver {
    public BaseComponent(SolverCore core) {
        super(core);
    }

    public SolveResult solve(IBaseConstraint constraint) {
        return constraint.match(IBaseConstraint.Cases.of(t -> SolveResult.empty(), f -> SolveResult.messages(constraint.getMessageInfo().withDefaultContent(MessageContent.of("False can never be satisfied."))), this::solve, this::solve, this::solve));
    }

    private SolveResult solve(CConj constraint) {
        return SolveResult.constraints(constraint.getLeft(), constraint.getRight());
    }

    private SolveResult solve(CExists constraint) {
        ISubstitution.Transient tsubst = PersistentSubstitution.Transient.of();
        constraint.getEVars().forEach(var -> tsubst.put((ITermVar)var, this.newVar((ITermVar)var)));
        ISubstitution.Immutable subst = tsubst.freeze();
        return SolveResult.constraints(Constraints.substitute(constraint.getConstraint(), subst));
    }

    private ITermVar newVar(ITermVar var) {
        return TermBuild.B.newVar(var.getResource(), this.fresh(var.getName()), var.getAttachments());
    }

    private SolveResult solve(CNew constraint) {
        ArrayList constraints = Lists.newArrayList();
        for (ITerm scope : constraint.getNVars()) {
            constraints.add(CEqual.of(scope, this.newScope(scope), constraint.getMessageInfo()));
        }
        return SolveResult.constraints(constraints);
    }

    private Scope newScope(ITerm term) {
        Scope scope = TermMatch.M.var(v -> Scope.of(v.getResource(), this.fresh(v.getName()))).match(term, this.unifier()).orElseGet(() -> Scope.of("", this.fresh("s")).withAttachments(term.getAttachments()));
        return scope;
    }
}

