/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.equality;

import java.util.function.Function;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.equality.CEqual;
import mb.nabl2.constraints.equality.CInequal;
import org.metaborg.util.functions.CheckedFunction1;

public interface IEqualityConstraint
extends IConstraint {
    public <T> T match(Cases<T> var1);

    public <T, E extends Throwable> T matchOrThrow(CheckedCases<T, E> var1) throws E;

    public static interface Cases<T> {
        public T caseEqual(CEqual var1);

        public T caseInequal(CInequal var1);

        public static <T> Cases<T> of(final Function<CEqual, T> onEqual, final Function<CInequal, T> onInequal) {
            return new Cases<T>(){

                @Override
                public T caseEqual(CEqual constraint) {
                    return onEqual.apply(constraint);
                }

                @Override
                public T caseInequal(CInequal constraint) {
                    return onInequal.apply(constraint);
                }
            };
        }
    }

    public static interface CheckedCases<T, E extends Throwable> {
        public T caseEqual(CEqual var1) throws E;

        public T caseInequal(CInequal var1) throws E;

        public static <T, E extends Throwable> CheckedCases<T, E> of(final CheckedFunction1<CEqual, T, E> onEqual, final CheckedFunction1<CInequal, T, E> onInequal) {
            return new CheckedCases<T, E>(){

                @Override
                public T caseEqual(CEqual constraint) throws Throwable {
                    return onEqual.apply(constraint);
                }

                @Override
                public T caseInequal(CInequal constraint) throws Throwable {
                    return onInequal.apply(constraint);
                }
            };
        }
    }
}

