/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.locals;

import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import mb.flowspec.runtime.interpreter.Types;

@TypeSystemReference(value=Types.class)
public class ArgToVarNode
extends Node {
    private final int argumentOffset;
    private final FrameSlot slot;

    public ArgToVarNode(int argumentOffset, FrameSlot slot) {
        this.argumentOffset = argumentOffset;
        this.slot = slot;
    }

    public void execute(VirtualFrame frame) {
        frame.setObject(this.slot, frame.getArguments()[this.argumentOffset]);
    }

    public static ArgToVarNode of(FrameDescriptor frameDescriptor, int offset, String name) {
        FrameSlot slot = frameDescriptor.findOrAddFrameSlot((Object)name);
        return new ArgToVarNode(offset, slot);
    }

    public String toString() {
        return "ArgToVarNode [argumentOffset=" + this.argumentOffset + ", slot=" + this.slot + "]";
    }
}

