/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.io.Closeable;
import java.io.IOException;
import javax.xml.namespace.QName;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PBuilder;
import oracle.dbtools.common.x3p.X3PFilter;
import oracle.dbtools.common.x3p.X3PHandler;
import oracle.dbtools.common.x3p.X3PReader;

public final class Event
implements Closeable {
    private final Object[] args;
    private final Type type;

    private Event(Type type, Object ... args) {
        this.type = type;
        this.args = args;
    }

    @Override
    public void close() throws IOException {
    }

    public void invoke(X3PFilter handler, X3PFilter.Mutator mutator) {
        switch (this.type) {
            case SD: {
                handler.startDocument(mutator);
                break;
            }
            case ED: {
                handler.endDocument(mutator);
                break;
            }
            case SP: {
                handler.startPrefixMapping((String)this.args[0], (String)this.args[1], mutator);
                break;
            }
            case SE: {
                handler.startElement((QName)this.args[0], (X3PAttributes)this.args[1], mutator);
                break;
            }
            case EE: {
                handler.endElement((QName)this.args[0], mutator);
                break;
            }
            case EP: {
                handler.endPrefixMapping((String)this.args[0], mutator);
                break;
            }
            case CH: {
                handler.characters((char[])this.args[0], (Integer)this.args[1], (Integer)this.args[2], mutator);
                break;
            }
            case PI: {
                handler.processingInstruction((String)this.args[0], (String)this.args[1], mutator);
                break;
            }
            case SK: {
                handler.skippedEntity((String)this.args[0], mutator);
            }
        }
    }

    public void invoke(X3PHandler handler) {
        if (handler != null) {
            switch (this.type) {
                case SD: {
                    handler.startDocument();
                    break;
                }
                case ED: {
                    handler.endDocument();
                    break;
                }
                case SP: {
                    handler.startPrefixMapping((String)this.args[0], (String)this.args[1]);
                    break;
                }
                case SE: {
                    handler.startElement((QName)this.args[0], (X3PAttributes)this.args[1]);
                    break;
                }
                case EE: {
                    handler.endElement((QName)this.args[0]);
                    break;
                }
                case EP: {
                    handler.endPrefixMapping((String)this.args[0]);
                    break;
                }
                case CH: {
                    handler.characters((char[])this.args[0], (Integer)this.args[1], (Integer)this.args[2]);
                    break;
                }
                case PI: {
                    handler.processingInstruction((String)this.args[0], (String)this.args[1]);
                    break;
                }
                case SK: {
                    handler.skippedEntity((String)this.args[0]);
                }
            }
        }
    }

    public X3PReader toReader() {
        X3PBuilder b = X3PBuilder.builder();
        switch (this.type) {
            case SD: {
                b.startDocument();
                break;
            }
            case ED: {
                b.endDocument();
                break;
            }
            case SP: {
                b.startPrefixMapping((String)this.args[0], (String)this.args[1]);
                break;
            }
            case SE: {
                b.startElement((QName)this.args[0], (X3PAttributes)this.args[1]);
                break;
            }
            case EE: {
                b.endElement((QName)this.args[0]);
                break;
            }
            case EP: {
                b.endPrefixMapping((String)this.args[0]);
            }
            case CH: {
                b.characters((char[])this.args[0], (Integer)this.args[1], (Integer)this.args[2]);
                break;
            }
            case PI: {
                b.processingInstruction((String)this.args[0], (String)this.args[1]);
                break;
            }
            case SK: {
                b.skippedEntity((String)this.args[0]);
            }
        }
        return b.build();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append((Object)this.type);
        b.append("(");
        if (Type.CH == this.type) {
            char[] ch = (char[])this.args[0];
            int offset = (Integer)this.args[1];
            int length = (Integer)this.args[2];
            b.append(ch, offset, length);
        } else {
            for (int i = 0; i < this.args.length; ++i) {
                Object arg = this.args[i];
                b.append(arg);
                if (i >= this.args.length - 1) continue;
                b.append(",");
            }
        }
        b.append(")");
        return b.toString();
    }

    Type getType() {
        return this.type;
    }

    public static Event characters(char[] ch, int start, int length) {
        char[] chars = new char[length];
        System.arraycopy(ch, start, chars, 0, length);
        return new Event(Type.CH, chars, 0, length);
    }

    public static void close(Event event) throws IOException {
    }

    public static Event endDocument() {
        return new Event(Type.ED, new Object[0]);
    }

    public static Event endElement(QName name) {
        return new Event(Type.EE, name);
    }

    public static Event endPrefixMapping(String prefix) {
        return new Event(Type.EP, prefix);
    }

    public static Event processingInstruction(String target, String data) {
        return new Event(Type.PI, target, data);
    }

    public static Event skippedEntity(String name) {
        return new Event(Type.SK, name);
    }

    public static Event startDocument() {
        return new Event(Type.SD, new Object[0]);
    }

    public static Event startElement(QName name, X3PAttributes atts) {
        return new Event(Type.SE, name, atts == null ? X3PBuilder.EMPTY_ATTRIBUTES : atts);
    }

    public static Event startPrefixMapping(String prefix, String uri) {
        return new Event(Type.SP, prefix, uri);
    }

    public static enum Type {
        CH,
        ED,
        EE,
        EP,
        PI,
        SD,
        SE,
        SK,
        SP;

    }
}

