/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;

public abstract class Throwables {
    private Throwables() {
    }

    public static void stackTrace(Appendable s, StackTraceElement[] trace) {
        Throwables.stackTrace(s, trace, 0, trace.length);
    }

    public static void stackTrace(Appendable s, Throwable t) {
        if (t != null) {
            try {
                s.append(t.toString());
                s.append('\n');
                StackTraceElement[] trace = t.getStackTrace();
                Throwables.stackTrace(s, trace);
                Throwable cause = t.getCause();
                if (cause != null) {
                    Throwables.stackTraceAsCause(s, cause, trace);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String stackTrace(Throwable t) {
        StringBuilder s = new StringBuilder();
        Throwables.stackTrace((Appendable)s, t);
        return s.toString();
    }

    private static void stackTrace(Appendable s, StackTraceElement[] trace, int offset, int length) {
        for (int i = offset; i < length; ++i) {
            try {
                s.append("\tat ");
                s.append(trace[i].toString());
                s.append('\n');
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void stackTraceAsCause(Appendable s, Throwable t, StackTraceElement[] causedTrace) {
        StackTraceElement[] trace = t.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        try {
            s.append("Caused by: ");
            s.append(t.toString());
            s.append('\n');
            Throwables.stackTrace(s, trace, 0, m + 1);
            if (framesInCommon != 0) {
                s.append("\t... " + framesInCommon + " more\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            Throwables.stackTraceAsCause(s, cause, trace);
        }
    }
}

