/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.builder.BuilderBase;
import oracle.dbtools.common.builder.Version;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Lookup;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Transform;

public final class Maps {
    private static final Class<Object> STOP_TYPE = Object.class;

    private Maps() {
    }

    public static <K, V> Lookup<V> asLookup(Map<K, V> map) {
        return new MapLookup(map);
    }

    public static Map<String, String> asMap(Properties properties) {
        Builder<String, String> map = Maps.builder();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            String key = name.toString();
            String value = properties.getProperty(key);
            map.add(key, value);
        }
        return (Map)map.build();
    }

    public static Map<String, String> asMap(ServletContext ctx) {
        Builder<String, String> map = Maps.builder();
        Enumeration names = ctx.getInitParameterNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            String key = name.toString();
            String value = ctx.getInitParameter(key);
            map.add(key, value);
        }
        return (Map)map.build();
    }

    public static Map<String, Object> beanAsMap(Object bean) {
        Builder<String, Object> properties = Maps.builder().kind(Kind.INSERTION_ORDER);
        if (!PrimitiveTypes.isPrimitive(bean)) {
            try {
                for (PropertyDescriptor prop : Introspector.getBeanInfo(bean.getClass(), STOP_TYPE).getPropertyDescriptors()) {
                    String name = prop.getName();
                    Method method = prop.getReadMethod();
                    if (STOP_TYPE.equals(method.getDeclaringClass())) continue;
                    Object value = method.invoke(bean, new Object[0]);
                    properties.add(name, value);
                }
            }
            catch (Throwable e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }
        return (Map)properties.build();
    }

    public static <K, V> Builder<K, V> builder() {
        return Maps.builder(Collections.emptyMap());
    }

    public static <K, V> Builder<K, V> builder(Map<K, V> existing) {
        return new Builder<K, V>(existing);
    }

    public static final <K, V> boolean contains(Map<K, V> items, Map<K, V> subset) {
        for (K k : subset.keySet()) {
            V expected = items.get(k);
            V actual = subset.get(k);
            if (expected != null && expected.equals(actual)) continue;
            return false;
        }
        return true;
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static String join(Map<?, ?> items, String delimiter, String separator) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iter = items.keySet().iterator();
        while (iter.hasNext()) {
            Object k = iter.next();
            Object v = items.get(k);
            b.append(k);
            b.append(delimiter);
            b.append(v);
            if (!iter.hasNext()) continue;
            b.append(separator);
        }
        return b.toString();
    }

    public static <K, V> Iterable<K> keys(Map<K, V> map) {
        return map.keySet();
    }

    public static <K, V> Map<K, V> merge(Map<K, V> existing, Map<K, V> overrides) {
        return (Map)Maps.builder(existing).add(overrides).build();
    }

    public static final <K, V> Iterable<V> select(Map<K, V> items, final Selector<K> condition) {
        return Iterables.transform(Iterables.select(items.entrySet(), new Selector<Map.Entry<K, V>>(){

            @Override
            public Boolean apply(Map.Entry<K, V> x) {
                return (Boolean)condition.apply(x.getKey());
            }
        }), new Transform<Map.Entry<K, V>, V>(){

            @Override
            public V apply(Map.Entry<K, V> x) {
                return x.getValue();
            }
        });
    }

    public static final <K, V> V selectFirst(Map<K, V> items, Selector<K> condition) {
        return Iterators.nextOrNull(Maps.select(items, condition).iterator());
    }

    public static Map<String, String> toMap(String ... propertyPairs) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (int i = 0; i < propertyPairs.length; ++i) {
            String key = propertyPairs[i];
            String value = propertyPairs[++i];
            properties.put(key, value);
        }
        return properties;
    }

    private static class MapState<K, V> {
        private Comparator<? super K> comparator = null;
        private Kind kind = Kind.INSERTION_ORDER;
        private final Map<K, V> map;

        public MapState(Kind kind, Map<K, V> map, Comparator<? super K> comparator) {
            this.kind = kind;
            this.map = new LinkedHashMap<K, V>(map);
            this.comparator = comparator;
        }
    }

    private static final class MapLookup<K, V>
    implements Lookup<V> {
        private final Map<K, V> map;

        private MapLookup(Map<K, V> map) {
            this.map = map;
        }

        public boolean equals(Object obj) {
            return this.map.equals(obj);
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            return this.map.toString();
        }
    }

    public static enum Kind {
        INSERTION_ORDER,
        SORTED,
        UNORDERED;


        public <K, V> Map<K, V> newInstance() {
            return this.newInstance(null);
        }

        public <K, V> Map<K, V> newInstance(Comparator<? super K> comparator) {
            AbstractMap map = null;
            switch (this) {
                case UNORDERED: {
                    map = new HashMap();
                    break;
                }
                case SORTED: {
                    map = new TreeMap(comparator);
                    break;
                }
                default: {
                    map = new LinkedHashMap();
                }
            }
            return map;
        }
    }

    public static class Builder<K, V>
    extends BuilderBase<Map<K, V>, MapState<K, V>> {
        protected Builder(Map<K, V> existing) {
            super(existing);
        }

        public Builder<K, V> add(K key, V value) {
            ((MapState)this.state()).map.put(key, value);
            this.modified();
            return this;
        }

        public Builder<K, V> add(Map<? extends K, ? extends V> values) {
            ((MapState)this.state()).map.putAll(values);
            this.modified();
            return this;
        }

        public Comparator<? super K> comparator() {
            return ((MapState)this.state()).comparator;
        }

        public Builder<K, V> comparator(Comparator<? super K> comparator) {
            ((MapState)this.state()).comparator = comparator;
            this.modified();
            return this;
        }

        public V get(Object key) {
            return ((MapState)this.state()).map.get(key);
        }

        public Kind kind() {
            return ((MapState)this.state()).kind;
        }

        public Builder<K, V> kind(Kind kind) {
            ((MapState)this.state()).kind = kind;
            this.modified();
            return this;
        }

        public Builder<K, V> put(K key, V value) {
            return this.add(key, value);
        }

        public Builder<K, V> putAll(Map<? extends K, ? extends V> values) {
            return this.add(values);
        }

        public Builder<K, V> remove(Object key) {
            ((MapState)this.state()).map.remove(key);
            this.modified();
            return this;
        }

        @Override
        protected MapState<K, V> existingState(Map<K, V> instance) {
            Kind kind = Kind.INSERTION_ORDER;
            Comparator comparator = null;
            if (instance instanceof SortedMap) {
                kind = Kind.SORTED;
                comparator = ((SortedMap)instance).comparator();
            }
            return new MapState<K, V>(kind, instance, comparator);
        }

        @Override
        protected Map<K, V> newInstance(MapState<K, V> state, Version version) {
            Comparator comparator = ((MapState)state).comparator;
            Kind kind = ((MapState)state).kind;
            Map map = kind.newInstance(comparator);
            map.putAll(((MapState)state).map);
            map = Kind.SORTED == kind ? Collections.unmodifiableSortedMap((SortedMap)map) : Collections.unmodifiableMap(map);
            return map;
        }

        @Override
        protected MapState<K, V> newState(MapState<K, V> existing) {
            Comparator comparator = ((MapState)existing).comparator;
            Kind kind = ((MapState)existing).kind;
            Map map = kind.newInstance(comparator);
            map.putAll(((MapState)existing).map);
            return new MapState(kind, map, comparator);
        }
    }
}

