/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.common.util.CallStacks;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Log;

public class Logs {
    private final ThreadLocal<HandlerProvider> handlerProvider = new ThreadLocal();
    private static final AtomicReference<Logs> INSTANCE = new AtomicReference();
    private static final HandlerProvider JDK_LOGGING = new JDKLoggingProvider();

    private Logs() {
    }

    private LogHandler _logHandler(Class<?> callingClass, int callerStackDepth) {
        HandlerProvider provider = this.handlerProvider.get();
        if (provider == null) {
            provider = JDK_LOGGING;
        }
        return provider.logHandler(callingClass, callerStackDepth);
    }

    private void _handlerProvider(HandlerProvider perThreadHandler) {
        this.handlerProvider.set(new IdempotentHandlerProvider(perThreadHandler));
    }

    private void _reset() {
        Closeables.close(this.handlerProvider.get());
        this.handlerProvider.remove();
    }

    public static LogHandler logHandler(Class<?> callingClass, int callerStackDepth) {
        return new LogRouter(callingClass, callerStackDepth);
    }

    public static void handlerProvider(HandlerProvider perThreadHandler) {
        Logs logs = INSTANCE.get();
        if (logs != null) {
            logs._handlerProvider(perThreadHandler);
        }
    }

    public static void reset() {
        Logs logs = INSTANCE.get();
        if (logs != null) {
            logs._reset();
        }
    }

    public static void setup() {
        INSTANCE.compareAndSet(null, new Logs());
    }

    public static void teardown() {
        INSTANCE.compareAndSet(INSTANCE.get(), null);
    }

    private static class LogRouter
    implements LogHandler {
        private final int callerStackDepth;
        private final Class<?> callingClass;

        private LogRouter(Class<?> callingClass, int callerStackDepth) {
            this.callingClass = callingClass;
            this.callerStackDepth = callerStackDepth + 1;
        }

        @Override
        public void console(String msg) {
            this.target().console(msg);
        }

        @Override
        public void fine(String msg) {
            this.target().fine(msg);
        }

        @Override
        public void fine(Throwable t) {
            this.target().fine(t);
        }

        @Override
        public void finer(String msg) {
            this.target().finer(msg);
        }

        @Override
        public void finer(Throwable t) {
            this.target().finer(t);
        }

        @Override
        public void finest(String msg) {
            this.target().finest(msg);
        }

        @Override
        public void finest(Throwable t) {
            this.target().finest(t);
        }

        @Override
        public void info(String msg) {
            this.target().info(msg);
        }

        @Override
        public void info(Throwable t) {
            this.target().info(t);
        }

        @Override
        public boolean isLoggable(Level level) {
            return this.target().isLoggable(level);
        }

        @Override
        public void severe(String msg) {
            this.target().severe(msg);
        }

        @Override
        public void severe(Throwable t) {
            this.target().severe(t);
        }

        @Override
        public void warning(String msg) {
            this.target().warning(msg);
        }

        @Override
        public void warning(Throwable t) {
            this.target().warning(t);
        }

        private LogHandler target() {
            Logs logs = (Logs)INSTANCE.get();
            if (null == logs) {
                return JDK_LOGGING.logHandler(this.callingClass, this.callerStackDepth);
            }
            return logs._logHandler(this.callingClass, this.callerStackDepth);
        }
    }

    private static class JDKLoggingProvider
    implements HandlerProvider {
        private JDKLoggingProvider() {
        }

        @Override
        public LogHandler logHandler(Class<?> callingClass, int callerStackDepth) {
            Logger target = Logger.getLogger(callingClass.getName());
            return new JDKLoggingHandler(target, callerStackDepth);
        }
    }

    private static class JDKLoggingHandler
    implements LogHandler {
        private final int callerStackDepth;
        private final Logger target;
        private static final int CALLER_STACK_DEPTH = 3;
        private static final PrintStream CONSOLE = System.out;

        private JDKLoggingHandler(Logger target, int callerStackDepth) {
            this.target = target;
            this.callerStackDepth = callerStackDepth;
        }

        @Override
        public void console(String msg) {
            CONSOLE.append(msg);
            CONSOLE.append('\n');
        }

        @Override
        public void fine(String msg) {
            this.log(Log.FINE, msg);
        }

        @Override
        public void fine(Throwable t) {
            this.log(Log.FINE, t);
        }

        @Override
        public void finer(String msg) {
            this.log(Log.FINER, msg);
        }

        @Override
        public void finer(Throwable t) {
            this.log(Log.FINER, t);
        }

        @Override
        public void finest(String msg) {
            this.log(Log.FINEST, msg);
        }

        @Override
        public void finest(Throwable t) {
            this.log(Log.FINEST, t);
        }

        @Override
        public void info(String msg) {
            this.log(Log.INFO, msg);
        }

        @Override
        public void info(Throwable t) {
            this.log(Log.INFO, t);
        }

        @Override
        public boolean isLoggable(Level level) {
            return this.target.isLoggable(level);
        }

        @Override
        public void severe(String msg) {
            this.log(Log.SEVERE, msg);
        }

        @Override
        public void severe(Throwable t) {
            this.log(Log.SEVERE, t);
        }

        @Override
        public void warning(String msg) {
            this.log(Log.WARNING, msg);
        }

        @Override
        public void warning(Throwable t) {
            this.log(Log.WARNING, t);
        }

        private void inferCaller(LogRecord lr) {
            StackTraceElement methodCaller = CallStacks.caller(this.callerStackDepth + 3);
            lr.setSourceClassName(methodCaller.getClassName());
            lr.setSourceMethodName(methodCaller.getMethodName());
        }

        private void log(Level level, String msg) {
            if (this.isLoggable(level)) {
                LogRecord lr = new LogRecord(level, msg);
                this.inferCaller(lr);
                this.target.log(lr);
            }
        }

        private void log(Level level, Throwable t) {
            if (this.isLoggable(level)) {
                LogRecord lr = new LogRecord(level, t == null ? "" : t.getMessage());
                lr.setThrown(t);
                this.inferCaller(lr);
                this.target.log(lr);
            }
        }
    }

    private static class IdempotentHandlerProvider
    implements HandlerProvider,
    Closeable {
        private final Map<HandlerKey, LogHandler> logHandlers = new HashMap<HandlerKey, LogHandler>();
        private final HandlerProvider target;

        private IdempotentHandlerProvider(HandlerProvider target) {
            this.target = target;
        }

        @Override
        public void close() throws IOException {
            this.logHandlers.clear();
            Closeables.close(this.target);
        }

        @Override
        public LogHandler logHandler(Class<?> callingClass, int callerStackDepth) {
            HandlerKey key = new HandlerKey(callingClass, callerStackDepth);
            LogHandler logHandler = this.logHandlers.get(key);
            if (logHandler == null) {
                logHandler = this.target.logHandler(callingClass, callerStackDepth);
                this.logHandlers.put(key, logHandler);
            }
            return logHandler;
        }
    }

    private static final class HandlerKey {
        private final int callerStackDepth;
        private final Class<?> callingClass;

        HandlerKey(Class<?> callingClass, int callerStackDepth) {
            this.callingClass = callingClass;
            this.callerStackDepth = callerStackDepth;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HandlerKey other = (HandlerKey)obj;
            if (this.callerStackDepth != other.callerStackDepth) {
                return false;
            }
            return !(this.callingClass == null ? other.callingClass != null : !this.callingClass.equals(other.callingClass));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.callerStackDepth;
            result = 31 * result + (this.callingClass == null ? 0 : this.callingClass.hashCode());
            return result;
        }
    }

    public static interface HandlerProvider {
        public LogHandler logHandler(Class<?> var1, int var2);
    }

    public static interface LogHandler {
        public void console(String var1);

        public void fine(String var1);

        public void fine(Throwable var1);

        public void finer(String var1);

        public void finer(Throwable var1);

        public void finest(String var1);

        public void finest(Throwable var1);

        public void info(String var1);

        public void info(Throwable var1);

        public boolean isLoggable(Level var1);

        public void severe(String var1);

        public void severe(Throwable var1);

        public void warning(String var1);

        public void warning(Throwable var1);
    }
}

