/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrayBuilder;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Ordering;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.SensitiveAssociativeArray;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.VersionedAssociativeArray;

public abstract class AssociativeArrays {
    private static final Empty EMPTY = new Empty();

    private AssociativeArrays() {
    }

    public static <E> AssociativeArray<E, E> asArray(E ... valuePairs) {
        LinkedHashMap<E, E> map = new LinkedHashMap<E, E>();
        for (int i = 0; i < valuePairs.length; ++i) {
            E key = valuePairs[i];
            E value = valuePairs[++i];
            map.put(key, value);
        }
        return AssociativeArrays.fromMap(map);
    }

    public static Properties asProperties(AssociativeArray<?, ?> assocArray) {
        SortedProperties props = new SortedProperties();
        for (Object key : assocArray) {
            props.put(key, assocArray.get(key));
        }
        return props;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> AssociativeArray<K, V> difference(AssociativeArray<K, V> parent, AssociativeArray<K, V> child) {
        Builder<K, V> diff = AssociativeArrays.builder();
        for (K key : child) {
            V parentValue;
            V value = child.get(key);
            if (value.equals(parentValue = parent.get(key))) continue;
            diff.add((Object)key, (Object)value);
        }
        return diff.build();
    }

    public static <K, V> boolean contains(AssociativeArray<K, V> array1, AssociativeArray<K, V> array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        for (K n2 : array2) {
            V v1 = array1.get(n2);
            V v2 = array2.get(n2);
            if ((v2 != null || v1 == null) && v2.equals(v1)) continue;
            return false;
        }
        return true;
    }

    public static AssociativeArray<Object, Object> detype(AssociativeArray<?, ?> target) {
        AssociativeArray<Object, Object> ick = target;
        return ick;
    }

    public static <K, V> void dump(AssociativeArray<K, V> assocArray, Appendable out) {
        Iterator<K> keys = assocArray.iterator();
        if (!keys.hasNext()) {
            return;
        }
        try {
            while (keys.hasNext()) {
                K key = keys.next();
                V value = assocArray.get(key);
                out.append(key.toString());
                out.append('=');
                out.append(value == null ? "null" : value.toString());
                out.append("\n");
            }
        }
        catch (IOException e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    public static <K, V> AssociativeArray<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> boolean equals(AssociativeArray<K, V> array1, AssociativeArray<K, V> array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        Iterator<K> i1 = array1.iterator();
        Iterator<K> i2 = array2.iterator();
        while (i1.hasNext()) {
            K n2;
            if (!i2.hasNext()) {
                return false;
            }
            K n1 = i1.next();
            if (!n1.equals(n2 = i2.next())) {
                return false;
            }
            V v1 = array1.get(n1);
            V v2 = array2.get(n2);
            if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
            return false;
        }
        return !i2.hasNext();
    }

    public static <K, V> AssociativeArray<K, V> fromMap(Map<K, V> map) {
        return new FromMap(map);
    }

    public static <K, V> AssociativeArray<K, V> merge(AssociativeArray<K, V> child, AssociativeArray<K, V> parent) {
        return new Merged(child, parent);
    }

    public static <K, V> AssociativeArray<K, V> sensitive(AssociativeArray<K, V> target, V substitute, Selector<K> isSensitive) {
        return new SensitiveAssociativeArray<K, V>(target, substitute, isSensitive);
    }

    public static <K, V> Map<K, V> toMap(AssociativeArray<K, V> array) {
        return new ToMap<K, V>(array);
    }

    public static <K, V> AssociativeArray<K, V> unmerge(AssociativeArray<K, V> values) {
        if (values instanceof MergedArray) {
            return ((MergedArray)((Object)values)).child();
        }
        return values;
    }

    public static <K, V> Iterable<V> values(AssociativeArray<K, V> values) {
        ArrayList<V> vals = new ArrayList<V>(values.size());
        for (K key : values) {
            vals.add(values.get(key));
        }
        return vals;
    }

    public static <K, V> VersionedAssociativeArray<K, V> versioned() {
        return new Versioned();
    }

    private static final class ToMap<K, V>
    implements Map<K, V> {
        private final Map<K, V> target;

        ToMap(AssociativeArray<K, V> array) {
            LinkedHashMap<K, V> target = new LinkedHashMap<K, V>();
            for (K key : array) {
                V value = array.get(key);
                target.put(key, value);
            }
            this.target = Collections.unmodifiableMap(target);
        }

        @Override
        public void clear() {
            this.target.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.target.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.target.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.target.entrySet();
        }

        @Override
        public boolean equals(Object obj) {
            return this.target.equals(obj);
        }

        @Override
        public V get(Object key) {
            return this.target.get(key);
        }

        @Override
        public int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.target.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return this.target.keySet();
        }

        @Override
        public V put(K key, V value) {
            return this.target.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.target.putAll(m);
        }

        @Override
        public V remove(Object key) {
            return this.target.remove(key);
        }

        @Override
        public int size() {
            return this.target.size();
        }

        public String toString() {
            return this.target.toString();
        }

        @Override
        public Collection<V> values() {
            return this.target.values();
        }
    }

    private static final class Versioned<K, V>
    extends Base<K, V>
    implements VersionedAssociativeArray<K, V> {
        private final AtomicReference<AssociativeArray<K, V>> version = new AtomicReference(AssociativeArrays.empty());

        private Versioned() {
        }

        @Override
        public V get(Object key) {
            return this.version.get().get(key);
        }

        @Override
        public Iterator<K> iterator() {
            return this.version.get().iterator();
        }

        @Override
        public int size() {
            return this.version.get().size();
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Versioned [version=");
            builder.append(System.identityHashCode(this.version.get()));
            builder.append(", ");
            builder.append(super.toString());
            builder.append("]");
            return builder.toString();
        }

        @Override
        public VersionedAssociativeArray.VersionedBuilder<K, V> versionBuilder() {
            return new VersioningBuilder();
        }

        private void publish(AssociativeArray<K, V> expectedVersion, AssociativeArray<K, V> newVersion) throws ConcurrentModificationException {
            boolean published = this.version.compareAndSet(expectedVersion, newVersion);
            if (!published) {
                throw new ConcurrentModificationException();
            }
        }

        private class VersioningBuilder
        implements VersionedAssociativeArray.VersionedBuilder<K, V> {
            private final AssociativeArray<K, V> expectedVersion;
            private final Builder<K, V> values;

            private VersioningBuilder() {
                this.expectedVersion = (AssociativeArray)Versioned.this.version.get();
                this.values = AssociativeArrays.builder();
                this.values.add(this.expectedVersion);
            }

            @Override
            public VersioningBuilder add(AssociativeArray<K, V> values) {
                this.values.add(values);
                return this;
            }

            @Override
            public VersioningBuilder add(K key, V value) {
                this.values.add(key, value);
                return this;
            }

            @Override
            public VersionedAssociativeArray<K, V> build() {
                Versioned.this.publish(this.expectedVersion, this.values.build());
                return Versioned.this;
            }

            @Override
            public VersioningBuilder clear() {
                this.values.clear();
                return this;
            }

            @Override
            public V get(Object key) {
                return this.values.get(key);
            }

            @Override
            public boolean isEmpty() {
                return this.values.isEmpty();
            }

            @Override
            public Iterator<K> iterator() {
                return this.values.iterator();
            }

            @Override
            public VersioningBuilder naturalSortOrder() {
                this.values.naturalSortOrder();
                return this;
            }

            @Override
            public VersioningBuilder remove(Object key) {
                this.values.remove(key);
                return this;
            }

            @Override
            public VersioningBuilder sortOrder(Comparator<? super K> comparator) {
                this.values.sortOrder(comparator);
                return this;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("VersioningBuilder [expectedVersion=");
                builder.append(System.identityHashCode(this.expectedVersion));
                builder.append(", values=");
                builder.append(this.values);
                builder.append("]");
                return builder.toString();
            }
        }
    }

    private static class Merged<K, V>
    extends Base<K, V>
    implements MergedArray<K, V> {
        private final AssociativeArray<K, V> child;
        private final AssociativeArray<K, V> parent;

        private Merged(AssociativeArray<K, V> child, AssociativeArray<K, V> parent) {
            this.child = child;
            this.parent = parent;
        }

        @Override
        public AssociativeArray<K, V> child() {
            return this.child;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.parent.comparator();
        }

        @Override
        public V get(Object key) {
            V value = this.child.get(key);
            if (value == null && this.parent != null) {
                value = this.parent.get(key);
            }
            return value;
        }

        @Override
        public Iterator<K> iterator() {
            if (this.parent == null) {
                return this.child.iterator();
            }
            AbstractSet keys = Ordering.SORTED == this.ordering() ? new TreeSet<K>(this.comparator()) : new LinkedHashSet();
            Iterables.add(keys, this.parent);
            Iterables.add(keys, this.child);
            return keys.iterator();
        }

        @Override
        public Ordering ordering() {
            return this.parent.ordering();
        }

        @Override
        public int size() {
            if (this.parent == null) {
                return this.child.size();
            }
            AbstractSet keys = Ordering.SORTED == this.ordering() ? new TreeSet<K>(this.comparator()) : new LinkedHashSet();
            Iterables.add(keys, this.parent);
            Iterables.add(keys, this.child);
            return keys.size();
        }
    }

    private static final class KeyToValue<K, V>
    implements Transform<K, V> {
        private final AssociativeArray<K, V> values;

        private KeyToValue(AssociativeArray<K, V> values) {
            this.values = values;
        }

        @Override
        public V apply(K key) {
            return this.values.get(key);
        }
    }

    private static final class FromMap<K, V>
    extends Base<K, V> {
        private final Comparator<? super K> comparator;
        private final Map<K, V> map;
        private final Ordering ordering;

        private FromMap(Map<K, V> map) {
            this.map = map;
            if (map instanceof SortedMap) {
                this.ordering = Ordering.SORTED;
                this.comparator = ((SortedMap)map).comparator();
            } else if (map instanceof LinkedHashMap) {
                this.ordering = Ordering.INSERTION;
                this.comparator = null;
            } else {
                this.ordering = Ordering.UNSPECIFIED;
                this.comparator = null;
            }
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.comparator;
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        @Override
        public Iterator<K> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public Ordering ordering() {
            return this.ordering;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    private static class Empty
    extends Base<Object, Object> {
        private Empty() {
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.empty();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    public static interface MergedArray<K, V> {
        public AssociativeArray<K, V> child();
    }

    public static class Builder<K, V>
    implements AssociativeArrayBuilder<Builder<K, V>, K, V> {
        private Map<K, V> values = new LinkedHashMap();

        private Builder() {
        }

        @Override
        public Builder<K, V> add(AssociativeArray<K, V> values) {
            for (K key : values) {
                V value = values.get(key);
                this.add((Object)key, (Object)value);
            }
            return this;
        }

        @Override
        public Builder<K, V> add(K key, V value) {
            this.values.put(key, value);
            return this;
        }

        @Override
        public AssociativeArray<K, V> build() {
            return AssociativeArrays.fromMap(this.values);
        }

        @Override
        public Builder<K, V> clear() {
            this.values.clear();
            return this;
        }

        @Override
        public V get(Object key) {
            return this.values.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return this.values.keySet().iterator();
        }

        @Override
        public Builder<K, V> naturalSortOrder() {
            return this.sortOrder((Comparator)null);
        }

        @Override
        public Builder<K, V> remove(Object key) {
            this.values.remove(key);
            return this;
        }

        @Override
        public Builder<K, V> sortOrder(Comparator<? super K> comparator) {
            Map<K, V> old = this.values;
            TreeMap<K, V> sorted = new TreeMap<K, V>(comparator);
            sorted.putAll(old);
            this.values = sorted;
            old.clear();
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Builder [values=");
            builder.append(this.values);
            builder.append("]");
            return builder.toString();
        }
    }

    public static abstract class Base<K, V>
    implements AssociativeArray<K, V> {
        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        public boolean equals(AssociativeArray<K, V> other) {
            return AssociativeArrays.equals(this, other);
        }

        public boolean equals(Object obj) {
            return obj instanceof AssociativeArray ? this.equals((AssociativeArray)obj) : false;
        }

        public int hashCode() {
            int h = 0;
            for (Object key : this) {
                h += key.hashCode();
                Object value = this.get(key);
                if (value == null) continue;
                h += value.hashCode();
            }
            return h;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public Ordering ordering() {
            return Ordering.UNSPECIFIED;
        }

        @Override
        public AssociativeArray<K, V> put(AssociativeArray<K, V> values) {
            return AssociativeArrays.merge(values, this);
        }

        @Override
        public AssociativeArray<K, V> put(K key, V value) {
            HashMap<K, V> values = new HashMap<K, V>();
            values.put(key, value);
            return this.put(AssociativeArrays.fromMap(values));
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("{");
            b.append(Iterables.join(Iterables.transform(this, new Transform<K, String>(){

                @Override
                public String apply(K key) {
                    StringBuilder b = new StringBuilder();
                    Object value = Base.this.get(key);
                    b.append(key);
                    b.append("=");
                    b.append(value);
                    return b.toString();
                }
            }), ", "));
            b.append("}");
            return b.toString();
        }
    }
}

