/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.timing;

import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.inject.Inject;
import oracle.dbtools.common.logging.LogAdapterBase;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.timing.ExecutionTimer;
import oracle.dbtools.common.timing.ExecutionTimerImpl;
import oracle.dbtools.common.timing.ExecutionTimerReport;
import oracle.dbtools.common.timing.ExecutionTimers;
import oracle.dbtools.common.timing.LogTimerReport;
import oracle.dbtools.common.timing.TimingPoint;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
@Service
public class ExecutionTimersProvider
implements ExecutionTimers {
    private final ExecutionTimerReport report;
    private static final ExecutionTimerReport LOGGER = new LogTimerReport(new Logging());

    public ExecutionTimersProvider() {
        this(LOGGER);
    }

    @Inject
    ExecutionTimersProvider(ExecutionTimerReport report) {
        this.report = report;
    }

    @Override
    public ExecutionTimers.Builder modify() {
        return new Builder(this);
    }

    @Override
    public ExecutionTimerReport report() {
        return this.report;
    }

    @Override
    public ExecutionTimer timer(TimingPoint timingPoint) {
        return new ExecutionTimerImpl(this.report, timingPoint);
    }

    private static class Logging
    extends LogAdapterBase {
        private final Logger log = Logger.getLogger(this.getClass().getName());

        protected Logging() {
            super(1);
        }

        @Override
        protected void log(LogRecord lr) {
            this.log.log(lr);
        }
    }

    private static final class Builder
    implements ExecutionTimers.Builder {
        private ExecutionTimerReport report;

        public Builder(ExecutionTimersProvider existing) {
            this.report = existing.report;
        }

        @Override
        public ExecutionTimersProvider build() {
            return new ExecutionTimersProvider(this.report);
        }

        @Override
        public Builder report(ExecutionTimerReport report) {
            this.report = report;
            return this;
        }
    }
}

