/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.reflect;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.inject.Inject;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.reflect.ClassLoaderResource;
import oracle.dbtools.common.reflect.ClassLoaderResources;
import oracle.dbtools.common.resources.Resource;
import oracle.dbtools.common.uri.URISandbox;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
public class ClassLoaderResourcesProvider
implements ClassLoaderResources {
    private static final URISandbox ROOT = URISandbox.sandbox(URIs.create("/"));

    @Inject
    ClassLoaderResourcesProvider() {
    }

    @Override
    public Resource get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.get(key.toString());
    }

    @Override
    public Resource get(String path) {
        path = ClassLoaderResourcesProvider.normalize(path);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(path);
        if (url == null) {
            return null;
        }
        return new ClassLoaderResource(path, url);
    }

    @Override
    public Iterable<Resource> getAll(String path) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> urls = classLoader.getResources(path);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                ClassLoaderResource resource = new ClassLoaderResource(path, url);
                resources.add(resource);
            }
        }
        catch (IOException e) {
            throw UnrecoverableException.unrecoverable(e);
        }
        return resources;
    }

    private static String normalize(String path) {
        URI uri = ROOT.uri(path);
        if (uri == null) {
            throw new IllegalArgumentException(path);
        }
        String absPath = uri.getPath();
        if (absPath.startsWith("/")) {
            absPath = absPath.substring(1);
        }
        return absPath;
    }
}

