/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.logging;

import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import oracle.dbtools.common.ecid.ECID;
import oracle.dbtools.common.immutables.Immutables;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Throwables;
import oracle.dbtools.common.util.Timestamps;

public class JDKLogFormatter
extends Formatter {
    private final Set<Field> fields;
    private static final Set<Field> ALL = Immutables.sets().builder().add(Iterables.iterable(Field.values())).build();

    public JDKLogFormatter() {
        this(ALL);
    }

    private JDKLogFormatter(Set<Field> fields) {
        this.fields = fields;
    }

    @Override
    public String format(LogRecord lr) {
        ECID ecid;
        StringBuilder b = new StringBuilder();
        if (this.fields.contains((Object)Field.TIMESTAMP)) {
            b.append(Timestamps.toPaddedString(lr.getMillis()));
            b.append(' ');
        }
        if (this.fields.contains((Object)Field.LEVEL)) {
            b.append(this.formatLevel(lr));
            b.append(' ');
        }
        if (this.fields.contains((Object)Field.ECID) && (ecid = this.ecid(lr)) != null) {
            b.append('<');
            b.append(ecid);
            b.append("> ");
        }
        b.append(this.formatMessage(lr));
        Throwable t = lr.getThrown();
        if (t != null) {
            b.append('\n');
            Throwables.stackTrace((Appendable)b, t);
        }
        b.append('\n');
        return b.toString();
    }

    public Builder modify() {
        return new Builder().show(this.fields);
    }

    private ECID ecid(LogRecord lr) {
        Object param;
        Object[] params = lr.getParameters();
        if (params != null && params.length > 0 && (param = params[0]) instanceof ECID) {
            return (ECID)param;
        }
        return null;
    }

    private String formatLevel(LogRecord lr) {
        String name = lr.getLevel().getName();
        return String.format("%1$-6s", name);
    }

    static enum Field {
        ECID,
        LEVEL,
        TIMESTAMP;

    }

    public static class Builder {
        private final Set<Field> fields = new TreeSet<Field>();

        public JDKLogFormatter build() {
            return new JDKLogFormatter(this.fields);
        }

        public Builder hide(Field field) {
            this.fields.remove((Object)field);
            return this;
        }

        public Builder hideAll() {
            this.fields.clear();
            return this;
        }

        public Builder show(Field field) {
            this.fields.add(field);
            return this;
        }

        public Builder show(Field ... fields) {
            return this.show(Iterables.iterable(fields));
        }

        public Builder show(Iterable<Field> fields) {
            Iterables.add(this.fields, fields);
            return this;
        }
    }
}

