/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.dbtools.common.immutables.ImmutableIterator;
import oracle.dbtools.common.immutables.ImmutableSet;
import oracle.dbtools.common.immutables.impl.CollectionFactory;
import oracle.dbtools.common.immutables.impl.IteratorImpl;
import oracle.dbtools.common.immutables.impl.SetBuilder;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Ordering;
import oracle.dbtools.common.util.Unsupported;

class SetImpl<V>
implements ImmutableSet<V>,
SortedSet<V> {
    private final Comparator<? super V> comparator;
    private final Ordering ordering;
    private final Set<V> target;
    private static final ImmutableSet<?> EMPTY = new SetImpl(CollectionFactory.set(0, Ordering.UNSPECIFIED, null), Ordering.UNSPECIFIED, null);
    private static final ImmutableSet<?> EMPTY_INSERTION = new SetImpl(CollectionFactory.set(0, Ordering.INSERTION, null), Ordering.INSERTION, null);
    private static final ImmutableSet<?> EMPTY_SORTED = new SetImpl(CollectionFactory.set(0, Ordering.SORTED, null), Ordering.SORTED, null);

    private SetImpl(Set<V> target, Ordering ordering, Comparator<? super V> comparator) {
        this.target = target;
        this.ordering = ordering;
        this.comparator = comparator;
    }

    @Override
    public boolean add(V e) {
        Unsupported.unsupported();
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        Unsupported.unsupported();
        return false;
    }

    @Override
    public void clear() {
        Unsupported.unsupported();
    }

    @Override
    public Comparator<? super V> comparator() {
        return this.comparator;
    }

    @Override
    public boolean contains(Object o) {
        return this.target.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.target.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        return this.target.equals(obj);
    }

    @Override
    public V first() {
        return this.sorted().first();
    }

    @Override
    public int hashCode() {
        return this.target.hashCode();
    }

    @Override
    public SortedSet<V> headSet(V toElement) {
        SortedSet<V> sorted = this.sorted().headSet(toElement);
        return (SortedSet)((Object)SetImpl.newInstance(sorted, this.ordering, this.comparator));
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public ImmutableIterator<V> iterator() {
        return new IteratorImpl<V>(this.target.iterator());
    }

    @Override
    public V last() {
        return this.sorted().last();
    }

    @Override
    public SetBuilder<V> modify() {
        return SetBuilder.newInstance(this.size(), this.ordering, this.comparator).add((Iterable)this);
    }

    @Override
    public Ordering ordering() {
        return this.ordering;
    }

    @Override
    public boolean remove(Object o) {
        Unsupported.unsupported();
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Unsupported.unsupported();
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Unsupported.unsupported();
        return false;
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public SortedSet<V> subSet(V fromElement, V toElement) {
        SortedSet<V> sorted = this.sorted().headSet(toElement);
        return (SortedSet)((Object)SetImpl.newInstance(sorted, this.ordering, this.comparator));
    }

    @Override
    public SortedSet<V> tailSet(V fromElement) {
        SortedSet<V> sorted = this.sorted().tailSet(fromElement);
        return (SortedSet)((Object)SetImpl.newInstance(sorted, this.ordering, this.comparator));
    }

    @Override
    public Object[] toArray() {
        return this.target.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.target.toArray(a);
    }

    public String toString() {
        return this.target.toString();
    }

    private SortedSet<V> sorted() {
        if (Ordering.SORTED == this.ordering) {
            return (SortedSet)this.target;
        }
        throw new IllegalStateException();
    }

    static <V> ImmutableSet<V> newInstance(Set<V> elements, Ordering ordering, Comparator<? super V> comparator) {
        ImmutableSet immutable;
        if (elements == null) {
            throw new NullPointerException();
        }
        if (NullOrEmpty.nullOrEmpty(elements)) {
            return SetImpl.empty(ordering);
        }
        if (elements instanceof ImmutableSet && Ordering.equals(immutable = (ImmutableSet)elements, ordering, comparator)) {
            return immutable;
        }
        elements = SetImpl.ordered(elements, ordering, comparator);
        return new SetImpl<V>(elements, ordering, comparator);
    }

    private static <V> ImmutableSet<V> empty(Ordering ordering) {
        ImmutableSet<?> empty = null;
        switch (ordering) {
            case UNSPECIFIED: {
                empty = EMPTY;
                break;
            }
            case SORTED: {
                empty = EMPTY_SORTED;
                break;
            }
            default: {
                empty = EMPTY_INSERTION;
            }
        }
        return empty;
    }

    private static <V> Set<V> ordered(Set<V> elements, Ordering ordering, Comparator<? super V> comparator) {
        switch (ordering) {
            case SORTED: {
                if (elements instanceof SortedSet) break;
                TreeSet<V> sorted = new TreeSet<V>(comparator);
                sorted.addAll(elements);
                elements = sorted;
                break;
            }
            case UNSPECIFIED: {
                if (!(elements instanceof HashSet)) {
                    elements = new HashSet<V>(elements);
                }
            }
            default: {
                if (elements instanceof LinkedHashSet) break;
                elements = new LinkedHashSet<V>(elements);
            }
        }
        return elements;
    }
}

