/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.common.immutables.ImmutableCollection;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.immutables.ImmutableSet;
import oracle.dbtools.common.immutables.impl.MapBase;
import oracle.dbtools.common.immutables.impl.MapBuilder;
import oracle.dbtools.common.util.KeyedLookup;
import oracle.dbtools.common.util.Ordering;

class CaseInsensitiveMap<V>
extends MapBase<String, V>
implements ImmutableMap<String, V> {
    private final ImmutableMap<String, V> caseNormalized;
    private final ImmutableMap<String, V> casePreserved;

    private CaseInsensitiveMap(ImmutableMap<String, V> target) {
        LinkedHashMap<String, String> keys = new LinkedHashMap<String, String>(target.size());
        ImmutableMap.Builder casePreserved = target.modify().clear();
        ImmutableMap.Builder normalized = target.modify().ordering(Ordering.INSERTION).clear();
        for (Map.Entry entry : target.entrySet()) {
            String key = (String)entry.getKey();
            String normalizedKey = CaseInsensitiveMap.normalize(key);
            String existing = (String)keys.get(normalizedKey);
            Object value = entry.getValue();
            if (existing == null) {
                keys.put(normalizedKey, key);
                casePreserved.add(key, value);
            } else {
                casePreserved.add(existing, value);
            }
            normalized.add(normalizedKey, value);
        }
        this.casePreserved = casePreserved.build();
        this.caseNormalized = normalized.build();
    }

    @Override
    public Comparator<? super String> comparator() {
        return this.casePreserved.comparator();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.caseNormalized.containsKey(CaseInsensitiveMap.normalize(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.casePreserved.containsValue(value);
    }

    @Override
    public ImmutableSet<Map.Entry<String, V>> entrySet() {
        return this.casePreserved.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        return this.casePreserved.equals(obj);
    }

    @Override
    public V get(Object key) {
        return this.caseNormalized.get(CaseInsensitiveMap.normalize(key));
    }

    @Override
    public int hashCode() {
        return this.casePreserved.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.casePreserved.isEmpty();
    }

    @Override
    public ImmutableSet<String> keySet() {
        return this.casePreserved.keySet();
    }

    public Builder<V> modify() {
        return new Builder().add(this.casePreserved);
    }

    @Override
    public Ordering ordering() {
        return this.casePreserved.ordering();
    }

    @Override
    public int size() {
        return this.casePreserved.size();
    }

    public String toString() {
        return this.casePreserved.toString();
    }

    @Override
    public ImmutableCollection<V> values() {
        return this.casePreserved.values();
    }

    private static String normalize(Object key) {
        return key.toString().toLowerCase();
    }

    static class Builder<V>
    implements ImmutableMap.Builder<String, V> {
        private final ImmutableMap.Builder<String, V> map = MapBuilder.newInstance(0, Ordering.INSERTION, null);

        Builder() {
        }

        public Builder<V> add(ImmutableMap<? extends String, ? extends V> m) {
            this.map.add(m);
            return this;
        }

        public Builder<V> add(KeyedLookup<? extends String, ? extends V> m) {
            this.map.add(m);
            return this;
        }

        public Builder<V> add(Map<? extends String, ? extends V> m) {
            this.map.add(m);
            return this;
        }

        public Builder<V> add(String key, V value) {
            this.map.add(key, value);
            return this;
        }

        @Override
        public ImmutableMap<String, V> build() {
            ImmutableMap<String, V> target = this.map.build();
            return new CaseInsensitiveMap(target);
        }

        public Builder<V> clear() {
            this.map.clear();
            return this;
        }

        @Override
        public Builder<V> comparator(Comparator<? super String> comparator) {
            this.map.comparator((Comparator<String>)comparator);
            return this;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.build().containsKey(key);
        }

        public boolean equals(Object obj) {
            return this.map.equals(obj);
        }

        @Override
        public V get(Object key) {
            return this.build().get(key);
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Builder<V> ordering(Ordering ordering) {
            this.map.ordering(ordering);
            return this;
        }

        public Builder<V> remove(Object key) {
            this.map.remove(key);
            return this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        public String toString() {
            return this.build().toString();
        }
    }
}

