/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.identifiers;

import java.security.SecureRandom;
import javax.inject.Inject;
import oracle.dbtools.common.identifiers.Identifier;
import oracle.dbtools.common.identifiers.IdentifierFactory;
import oracle.dbtools.common.util.Base64;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.logging.Log;

@Provides(value={RandomIdentifiers.class, IdentifierFactory.class})
public class RandomIdentifiers
implements IdentifierFactory {
    private final Log log;
    private static final String PREFIX = "rid:";
    private static final SecureRandom RNG = new SecureRandom();

    @Inject
    public RandomIdentifiers(Log log) {
        this.log = log;
    }

    public Identifier identifier() {
        byte[] randomBytes = new byte[16];
        RNG.nextBytes(randomBytes);
        return new RandomIdentifer(randomBytes);
    }

    @Override
    public Identifier parse(String text) {
        if (text.startsWith(PREFIX)) {
            try {
                byte[] bytes = Base64.safeBase64ToByteArray(text.substring(PREFIX.length()));
                return new RandomIdentifer(bytes);
            }
            catch (IllegalArgumentException e) {
                this.log.warning((Throwable)e);
            }
        }
        return null;
    }

    private static class RandomIdentifer
    implements Identifier {
        private final byte[] bytes;

        RandomIdentifer(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public int length() {
            return this.toString().length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(RandomIdentifiers.PREFIX);
            builder.append(Base64.byteArrayToSafeBase64(this.bytes));
            return builder.toString();
        }
    }
}

