/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import java.util.Collection;
import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.EdgeChecker;
import oracle.dbtools.common.graph.EdgeFormatter;
import oracle.dbtools.common.graph.EdgeRendererBase;
import oracle.dbtools.common.graph.TextRenderer;
import oracle.dbtools.common.graph.Vertex;
import oracle.dbtools.common.graph.VertexFormatter;

public class TextRendererImpl<V, E>
implements TextRenderer<V, E> {
    private final EdgeChecker<V, E> edgeChecker;
    private final EdgeFormatter<V, E> edgeFormatter;
    private final VertexFormatter<V> vertexFormatter;

    protected TextRendererImpl(EdgeChecker<V, E> edgeChecker, EdgeFormatter<V, E> edgeFormatter, VertexFormatter<V> vertexFormatter) {
        this.edgeChecker = edgeChecker;
        this.edgeFormatter = edgeFormatter;
        this.vertexFormatter = vertexFormatter;
    }

    @Override
    public EdgeChecker<V, E> edgeChecker() {
        return this.edgeChecker;
    }

    @Override
    public EdgeFormatter<V, E> edgeFormatter() {
        return this.edgeFormatter;
    }

    @Override
    public GraphVizRenderer<V, E> using(StringBuilder text) {
        return new GraphVizRenderer<V, E>(text, this.edgeChecker, this.edgeFormatter, this.vertexFormatter);
    }

    @Override
    public VertexFormatter<V> vertexFormatter() {
        return this.vertexFormatter;
    }

    public static abstract class RendererBase<V, E>
    extends EdgeRendererBase<V, E>
    implements TextRenderer.Renderer<V, E> {
        protected RendererBase(StringBuilder text, EdgeChecker<V, E> edgeChecker, EdgeFormatter<V, E> edgeFormatter, VertexFormatter<V> vertexFormatter) {
            super(text, edgeChecker, edgeFormatter, vertexFormatter);
        }

        @Override
        public StringBuilder done() {
            return this.text;
        }

        @Override
        public RendererBase<V, E> render(Iterable<? extends Vertex<V, E>> vertices) {
            for (Vertex<V, E> vertex : vertices) {
                this.render((Vertex)vertex);
            }
            return this;
        }

        @Override
        public abstract RendererBase<V, E> render(V var1, V var2, E var3);

        @Override
        public RendererBase<V, E> render(Vertex<V, E> vertex) {
            V value = vertex.value();
            Collection<Edge<V, E>> edges = vertex.edges();
            if (vertex.isOrphan()) {
                this.render(value);
            } else {
                V from = value;
                for (Edge<V, E> edge : edges) {
                    V to = edge.destination().value();
                    E using = edge.value();
                    this.render((Object)from, (Object)to, (Object)using);
                }
            }
            return this;
        }

        @Override
        public RendererBase<V, E> render(Vertex<V, E>[] vertices) {
            for (Vertex<V, E> vertex : vertices) {
                this.render((Vertex)vertex);
            }
            return this;
        }
    }

    public static class GraphVizRenderer<V, E>
    extends RendererBase<V, E> {
        protected GraphVizRenderer(StringBuilder text, EdgeChecker<V, E> edgeChecker, EdgeFormatter<V, E> edgeFormatter, VertexFormatter<V> vertexFormatter) {
            super(text, edgeChecker, edgeFormatter, vertexFormatter);
            text.append("digraph g {\n");
        }

        @Override
        public StringBuilder done() {
            this.text.append("}");
            return this.text;
        }

        @Override
        public GraphVizRenderer<V, E> render(V orphan) {
            this.text.append("\t");
            this.text.append(this.vertexToString(orphan));
            this.text.append(";\n");
            return this;
        }

        @Override
        public GraphVizRenderer<V, E> render(V from, V to, E using) {
            this.text.append("\t");
            this.text.append(this.vertexToString(from));
            this.text.append(" -> ");
            this.text.append(this.vertexToString(to));
            this.text.append(" [");
            if (!this.edgeChecker.follow(from, using, to)) {
                this.text.append("style=dashed, ");
            }
            this.text.append("label=\"");
            this.text.append(this.edgeToString(using, to));
            this.text.append("\"];\n");
            return this;
        }
    }
}

